/* mbed library for touchscreen connected to 4 mbed pins
 * derive from SPI_TFT lib
 * Copyright (c) 2011 Peter Drescher - DC2PD
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MYMBED_TOUCH_H
#define MYMBED_TOUCH_H

#include "mbed.h"

#include "SeeedStudioTFTv2.h"
#ifndef USE_SDCARD
#error "Shoud be defined USE_SDCARD in SeeedStudioTFTv2.0.h
#endif


class MySeeedStudioTFTv2 : public SeeedStudioTFTv2
{
public:
    /** create a TFT with touch object connected to the pins:
     *
     * @param pin xp resistiv touch x+
     * @param pin xm resistiv touch x-
     * @param pin yp resistiv touch y+
     * @param pin ym resistiv touch y-
     * @param mosi,miso,sclk SPI connection to TFT
     * @param cs pin connected to CS of display
     * @param reset pin connected to RESET of display
     * based on my SPI_TFT lib
     */
    MySeeedStudioTFTv2(PinName xp, PinName xm, PinName yp, PinName ym,
                     PinName mosi, PinName miso, PinName sclk,
                     PinName csTft, PinName dcTft, PinName blTft,
                     PinName csSd);

    int DrawBitmapFile(FILE * fp);
};

#endif
