#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#include "FTPClient.h"
#include "MySeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.1.100"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.1.1"

#define FTP_SERVER_IP "192.168.1.200"

#define _MAX_FNAME_LEN_   127
#define _FTP_UPDATE_TIME_  20


Serial uart(USBTX, USBRX);

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // LPC1768 MBD2PMD
//SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD
//SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // K64F
//SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 

EthernetInterface eth;

DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status


MySeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);


FTPClient myFTP("/sdc");  // mountname in MySeeedStudioTFTv2

Ticker ledTick;

uint32_t ftp_time_1s = 0;

char myfilelist[MAX_SS] = {0,};

void ledTickfunc()
{
    led1 = !led1;
    if(ftp_time_1s)
    {
        if(ftp_time_1s++ > _FTP_UPDATE_TIME_) ftp_time_1s = 0;
    }
}


int main (void)
{
    int ret;
    char* tok = NULL;
    char* lasts = NULL;
    char filename[_MAX_FNAME_LEN_];
    FILE* fp;
   
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");

    //eth.init(); //Use DHCP
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    uart.printf("Connecting\n");
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());

//    Check File System
    uart.printf("Checking File System\n");
    DIR *d = opendir("/sdc/");
    if (d != NULL) {
        uart.printf("SD Card Present\n");
        closedir(d);
    } else {
        uart.printf("SD Card Root Directory Not Found\n");
    }

    ledTick.attach(&ledTickfunc,1);

    while(1)
    {
        if(ftp_time_1s == 0)
        {
            //Configure the display driver
            ftp_time_1s = 1;
            TFT.background(Black);
            TFT.foreground(White);
            TFT.set_font((unsigned char*) Arial12x12);    
            TFT.cls();

            TFT.locate(0,0);
            TFT.printf(" UPDATING PHOTO\n");
            TFT.printf("==================\n\n");
        
            if(myFTP.open("192.168.77.210", 21, "user", "pass"))
            {
                printf("Connect Success to FTPServer\r\n");
                TFT.printf("Connected to FTP Server\n");

                myFTP.ls(myfilelist);
            
                if(*myfilelist !=0)
                {
                    tok = myfilelist;
                    while(tok)
                    {
                        tok = strtok_r(tok,"\r\n",&lasts);
                        if(tok != NULL)
                        {
                            printf("tok=%s\r\n",tok);
                            if(strstr(tok,"bmp"))
                            {
                                sprintf(filename,"/sdc/%s",tok);
                                fp = fopen(filename, "r");
                                printf("fp=%d\r\n",fp);
                                if(fp==NULL)
                                {
                                    myFTP.getfile(tok);
                                    printf("Get File : %s\r\n",tok);
                                    TFT.printf("   New file : %s\n", tok);
                                }
                                else fclose(fp);
                            }
                            tok = lasts; 
                        }
                    }
                }
                else TFT.printf(" Empty FTP Server\n");
                TFT.printf("\n UPDATE DONE\n");
                myFTP.quit();
            }
            else
            {
                TFT.printf(" Can't connect to FTP Server\n\n");
                TFT.printf(" UPDATE FAIL\n");
            }
            TFT.printf("==================\n");
        }
     
        d = opendir("/sdc/");
        if(d != NULL)
        {
            struct dirent *p;
            while((p = readdir(d)) != NULL) 
            {
                sprintf(filename, "/sdc/%s", p->d_name);
                uart.printf("%s\n", filename);
                DIR *subDir = opendir(filename);
                if (subDir != NULL) uart.printf("Skip a sub-directory\r\n");
                else 
                {
                    fp = fopen(filename, "r");
                    if(fp)
                    {
                        TFT.DrawBitmapFile(fp);
                        TFT.locate(1,1);
                        TFT.printf("%s", filename);
                        fclose(fp);
                    }
                    else uart.printf("Can't open file %s\r\n", filename);
                }
            }
        }
        else
        {
            TFT.cls();
            TFT.locate(0,0);
            TFT.printf(" No SD Card !!!\n");
            TFT.printf(" Insert a SD card\n");
        }
    }
    
}
