/* mbed library for resistive touch pads
 * uses 4 pins - 2 IO and 2 Analog

 * c 2011 Peter Drescher - DC2PD
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "mbed.h"
#include "MySeeedStudioTFTv2.h"

#define TFT_DEBUG

#ifdef TFT_DEBUG
extern Serial uart;
#endif


MySeeedStudioTFTv2::MySeeedStudioTFTv2(PinName xp, PinName xm, PinName yp, PinName ym,
                     PinName mosi, PinName miso, PinName sclk,
                     PinName csTft, PinName dcTft, PinName blTft,
                     PinName csSd) : SeeedStudioTFTv2(xp,xm,yp,ym,mosi,miso,sclk,csTft,dcTft,blTft,csSd)
{
    SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.frequency(18000000);
    SeeedStudioTFTv2::SDFileSystem::_spi.frequency(24000000);     
}

int MySeeedStudioTFTv2::DrawBitmapFile(FILE * fp)
{
   
    char img[3*240];
    uint32_t imgsize = 0;
    uint32_t offset = 0;
    uint32_t imgw = 0;
    uint32_t imgh = 0;
    char colbits = 0;
    char compress = 0;
    uint16_t col;

    int i, j;
 
    if(fp == NULL) return -1;
    if(fgetc(fp) != 0x42) return -2;
    if(fgetc(fp) != 0x4D) return -2;

    for(i = 0; i < 4; i++)
    {
        imgsize += (((uint32_t)fgetc(fp)) << i*8);
    }
#ifdef TFT_DEBUG
    uart.printf("BMP SIZE:%d\r\n",imgsize);
#endif
    fseek(fp,4,SEEK_CUR);
    for(i = 0; i < 4; i++)
    {
        offset += (((uint32_t)fgetc(fp)) << i*8);
    }
#ifdef TFT_DEBUG    
    uart.printf("BMP OFFSET:%d\r\n",offset);
#endif
    fseek(fp,4,SEEK_CUR);
    for(i = 0; i < 4; i++)
    {
        imgw += (((uint32_t)fgetc(fp)) << i*8);
    }
    if(imgw > 240) return -3;
    
    for(i = 0; i < 4; i++)
    {
        imgh += (((uint32_t)fgetc(fp)) << i*8);
    }
    if(imgh > 320) return -3;
    
    fseek(fp,2,SEEK_CUR);
    colbits = fgetc(fp);
    //if(colbits != 16 || colbits != 24) return -4;
    fgetc(fp);
    if((compress=fgetc(fp)) != 0)
    {
    #ifdef TFT_DEBUG    
        uart.printf("Not supported compress : %d\r\n",compress);
    #endif
        return -4;    
    }
    

#ifdef TFT_DEBUG    
    uart.printf("RESOL : %d col, %d X %d",colbits,imgw,imgh);
#endif    
    
    fseek(fp, offset, SEEK_SET);
    for (j = imgh-1; j >= 0; j--)        //Lines
    {  
        fread(img,sizeof(char),imgw*3,fp);
        window(0, j, imgw, 1);    
        wr_cmd(0x2C);  // send pixel
    #ifndef TARGET_KL25Z  // 16 Bit SPI 
        SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.format(16,3);
    #endif                            // switch to 16 bit Mode 3

        for(i = 0; i < imgw; i++)
        {
/*            if(colbits == 16)
            {
                col = (uint16_t)img[2*i+1];
                col <<= 8;
                col += (uint16_t)img[2*i];
            }
            else if(colbits == 24) */
            {
                col = RGB((uint16_t)img[3*i+2],(uint16_t)img[3*i+1], (uint16_t)img[3*i]);
            }
        #ifdef TFT_DEBUG    
            //uart.printf("RGB(%d): (%d,%d,%d) -> %04X\r\n ",i,img[3*i+2],img[3*i+1],img[3*i],col);
        #endif    

        #ifdef TAGET_KL25Z
            SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.write((char)(col>>8));
            SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.write((char)col);
        #else
           SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.write(col);
        #endif
        }
        SeeedStudioTFTv2::SPI_TFT_ILI9341::_cs = 1;
        #ifndef TARGET_KL25Z  // 16 Bit SPI 
            SeeedStudioTFTv2::SPI_TFT_ILI9341::_spi.format(8,3);
        #endif
 
    }
    WindowMax();
    
    return 0;
}