#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#include "FTPClient.h"
#include "MySeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_MOSI        D11
#define PIN_MISO        D12
#define PIN_SCLK        D13
#define PIN_CS_TFT      D5
#define PIN_DC_TFT      D6
#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.77.100"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.77.1"

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

Serial uart(USBTX, USBRX);

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // LPC1768 MBD2PMD
//SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD
//SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // K64F
//SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 

EthernetInterface eth;

/*
char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;
*/

DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status



MySeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT, PIN_CS_SD);


FTPClient myFTP("/sdc");  // mountname in MySeeedStudioTFTv2

Ticker ledTick;


char myfilelist[MAX_SS] = {0,};

void ledTickfunc()
{
    led1 = !led1;
}


int main (void)
{
    int ret;
    char* tok = NULL;
    char* lasts = NULL;
    char filename[20];
    FILE* fp;
    
    
    ledTick.attach(&ledTickfunc,0.5);

//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\n");

//    Check File System
    uart.printf("Checking File System\n");
    DIR *d = opendir("/sdc/");
    if (d != NULL) {
        uart.printf("SD Card Present\n");
    } else {
        uart.printf("SD Card Root Directory Not Found\n");
    }

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    //eth.init(); //Use DHCP
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    uart.printf("Connecting\n");
    eth.connect();
    uart.printf("IP Address is %s\n", eth.getIPAddress());

    //Configure the display driver
    TFT.background(Black);
    TFT.foreground(White);
    TFT.set_font((unsigned char*) Arial12x12);    
    TFT.cls();


    if(myFTP.open("192.168.77.210", 21, "user", "pass"))
    {
        printf("Connect Success to FTPServer\r\n");
    }
    myFTP.ls(myfilelist);
   

    if(*myfilelist !=0)
    {
        tok = myfilelist;
        while(tok)
        {
            tok = strtok_r(tok,"\r\n",&lasts);
            if(tok != NULL)
            {
                printf("tok=%s\r\n",tok);
                if(strstr(tok,"bmp"))
                {
                    sprintf(filename,"/sdc/%s",tok);
                    fp = fopen(filename, "r");
                    printf("fp=%d\r\n",fp);
                    if(fp==NULL)
                    {
                        myFTP.getfile(tok);
                        printf("Get File : %s\r\n",tok);
                    }
                    else fclose(fp);
                }
                tok = lasts; 
            }
            
        }
    }
    myFTP.quit();

/*
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                uart.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
*/

    for(int i=0; i < 4; i++)
    {
    TFT.set_orientation(i);
    fp = fopen("/sdc/island.bmp", "r");
    if((ret = TFT.DrawBitmapFile(fp)) < 0)
    {
        printf("error : %d\r\n",ret);
    }
    fclose(fp);
    TFT.locate(120-6*strlen("islasn.bmp"),308);
    TFT.printf("red24.bmp");
    fp = fopen("/sdc/tiger24.bmp", "r");
    if((ret = TFT.DrawBitmapFile(fp)) < 0)
    {
        printf("error : %d\r\n",ret);
    }
    fclose(fp);
    TFT.locate(120-6*strlen("tiger24.bmp"),308);
    TFT.printf("tiger24.bmp");
    printf("press key");getchar();
    }
}
