#ifndef FILTER_DEBUG_H
#define FILTER_DEBUG_H

int PrintFilterSymbol( short* p )
{
    int shift = 0;

    if( *p > 0 && *p < 128 )
    {
        printf( "%d ", *p ); return 0;
    }
    if( *p > 0 && *p < 256 )
    {
        printf( "0x%02.2X ", *p ); return 0;
    }
    if( *p < SEQ || *p > NAKW )
    {
        printf( "0x%04.4X ", *p ); return 0;
    }
    switch( *p )
    {
        case SEQ: printf( "SEQ " ); return 0;
        case E7_: printf( "E7_ " ); return 0;
        case E8_: printf( "E8_ " ); return 0;
        case E14: printf( "E14 " ); return 0;
        case NOP: printf( "NOP " ); return 0;
        case VMC: printf( "VMC " ); return 0;
        case VM_: printf( "VM_ " ); return 0;
        case VC_: printf( "VC_ " ); return 0;
        case VA_: printf( "VA_ " ); return 0;
        case VB_: printf( "VB_ " ); return 0;
        case VD_: printf( "VD_ " ); return 0;
        case VN_: printf( "VN_ " ); return 0;
        case ADD: printf( "ADD " ); return 0;
        case SUB: printf( "SUB " ); return 0;
        case MUL: printf( "MUL " ); return 0;
        case DIV: printf( "DIV " ); return 0;
        case MOD: printf( "MOD " ); return 0;
        case BIT: printf( "BIT " ); return 0;
        case BOR: printf( "BOR " ); return 0;
        case BAN: printf( "BAN " ); return 0; 
        case BNO: printf( "BNO " ); return 0;
        case BSL: printf( "BSL " ); return 0;
        case BSR: printf( "BSR " ); return 0;
        case MAP: printf( "MAP " ); return 0;
        case RPN: printf( "RPN " ); return 0;
        case NPN: printf( "NPN " ); return 0;
        case CSB: printf( "CSB " ); return 0; 
        case CSE: printf( "CSE " ); return 0;
        case CS1: printf( "CS1 " ); return 0;
        case CS2: printf( "CS2 " ); return 0;
        case NAKW:printf( "NAKW "); return 0;
        case RAW: printf( "* "   ); return 0;
    }
    if( *p > CID && *p < CUL )
    {
        char buffer[17];
        while( *p != CID ) buffer[shift++]= (char)( *p++ - CID );
        buffer[shift] = 0;
        printf( "%s ", buffer );
        return shift;
    }
    return 0;
}

#endif