#ifndef MEMORY_H
#define MEMORY_H

//_____________________________________________________________________________
class Memory
{//""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
private:
public:
    char    Name[16];
    short   Value;
    Memory() { Name[0] = 0; Value = 0; }
    Memory( char* n, short v ) { strncpy( Name, n, 16 ); Value = v; }
    ~Memory() {}
};
//_____________________________________________________________________________
class MemList
{//""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
private:
    short   allocated_; // size of allocated list
public:
    short   Count;     // size of initialized list
    Memory* List;      // list of names

    MemList() : Count(0), List(NULL) {}
    
    ~MemList()
    {
        if( List != NULL ) free( List );
        Count = allocated_ = 0;
    }
    void Add( Memory &m )
    {
        int n = Find( m.Name );
        if( n == -1 )
        {
            if( Count == allocated_ ) List = (Memory*)realloc( List, ( allocated_ += 5 ) * sizeof( Memory ) );
            List[ Count++ ] = m;
        }
        else
            List[n].Value = m.Value;
    }
    void Add( char* name, short value )
    {
        int n = Find( name );
        if( n == -1 )
        {
            if( Count == allocated_ ) List = (Memory*)realloc( List, ( allocated_ += 5 ) * sizeof( Memory ) );
            List[ Count++ ] = Memory( name, value );
        }
        else
            List[n].Value = value;
    }
    short Find( char* name )
    {
        for( short i = 0 ; i < Count ; i++ )
            if( strcmp( List[i].Name, name ) == 0 )
                return i;
        return -1;
    }
    short Get( char* name )
    {
        for( short i = 0 ; i < Count ; i++ )
            if( strcmp( List[i].Name, name ) == 0 )
                return List[i].Value;
        return 0;
    }
    void Set( char* name, short value )
    {
        for( short i = 0 ; i < Count ; i++ )
            if( strcmp( List[i].Name, name ) == 0 )
            {
                List[i].Value = value;
                break;
            }
    }
};

#endif