#include "mbed.h"                                                                   //Invoegen van de mbed bibliotheek.
#include "TextLCD.h"                                                                //Invoegen van de LCD bibliotheek.
#include "ds1307.h"                                                                 //Invoegen van de de1307 bibliotheek voor de CLK.
#include "EthernetNetIf.h"                                                          //Invoegen van de ethernet bibliotheek.
#include "HTTPServer.h"                                                             //Invoegen van de HTTP bibliotheek.
#include "RPCFunction.h"                                                            //Invoegen van de RPC bibliotheek.
////////////////////////////////////////////////////////////////////////////////////
TextLCD lcd(p21, p22, p23, p24, p27, p28);                                          //Instellen van de LCD pinnen. rs, e, d4-d7
AnalogIn LM35_1(p19);                                                               //Analoge ingang voor eerste LM35 toewijzen op welke pin.
AnalogIn LM35_2(p20);                                                               //Analoge ingang voor tweede LM35 toewijzen op welke pin.
Serial pc(USBTX, USBRX);                                                            //Zorgen dat we een seriële communicatie tussen computer en MBED kunnen opzetten waardoor we de printf lijnen kunnen gaan uitlezen.
DigitalOut LEDJE1  (p6);                                                            //Uitgang voor LED op breadboard voor chauffage aan/uit.
DigitalOut LEDJE2  (p7);                                                            //Uitgang voor LED op breadboard voor chauffage aan/uit.
InterruptIn knopHOGER(p8);                                                          //Aanmaken van ingangknop voor temperatuur hoger te kunnen instellen onder interrupt.
InterruptIn knopLAGER(p30);                                                         //Aanmaken van ingangknop voor temperatuur lager te kunnen instellen onder interrupt.
InterruptIn aanuitknop(p5);                                                         //Aanmaken van aan/uit knop voor het systeem op of af te zetten onder interrupt.
DigitalOut relais(p29);                                                             //Aanmaken van een uitgangspin voor het aansturen van de Relais.
PwmOut motorout(p25);                                                               //Aanmaken van PWM pin voor het aansturen van de servo-motor onder PWM.
DS1307 my1307(p9,p10);                                                              //Opstarten van de DS1307 en de pinnen voor connectie mee geven.
LocalFileSystem fs("webfs");                                                        //Instellingen voor HTTP
LocalFileSystem local("local");                                                     //Instellingen voor HTTP, /local/Project.htm gaan we gebruiken, hierbij komt ons project lokaal te staan.
////////////////////////////////////////////////////////////////////////////////////
int c=0;                                                                            //Aanmaken van de c variable voor HTTP, hierbij geven we deze variable de waarde 0 mee.
float waarde = 25;                                                                  //Aanmaken van de waarde variable voor een instel temperatuur mee te geven.
float temp2;                                                                        // Aanmaken van de temp2 variable, deze dient voor de temperatuur van de tweede LM35 in op te slaan.
bool aanuit = 0;                                                                    //Aanmaken van een variable voor te kijken of het programma/MBED aan of uit staat.
float temp1;                                                                        //Aanmaken van de temp1 variable, deze dient voor de temperatuur van de eerste LM35 in op te slaan.                                                                            // variable aanmaken voor temp van 1ste LM35 in te steken.                                                                            // variable aanmaken voor temp van 2de LM35 in te steken.
float afronden;                                                                     //Aanmaken van de variable afronden, deze gaat dienen
float hoekverdraaiing;                                                                       //Aanmaken van de variable graden, deze dient voor het weergeven van onze temperatuur waarde in °C
float verschilgraden;
float stand;
float lijn;
float counter;                                                                      //We gaan de variable counter aan maken voor het tellen van hoeveel keer we op hoger of lager hebben geduwd voor de ingestelde waarde te verhogen of verlagen.
float flaginstellen = 0;                                                            //We gaan de variable flaginstellen aanmaken voor te gaan kijken of wij willen gaan instellen van de waardes of het programma willen uitvoeren.
int sec = 0;                                                                        //We gaan de variable sec aanmaken zodat we de seconden kunnen instellen die er op ons LCD moet komen te staan.
int minuten = 0;                                                                    //We gaan de variable minuten aanmaken zodat we de minuten kunnen instellen die er op ons LCD moet komen te staan.
int hours = 0;                                                                      //We gaan de variable hours aanmaken zodat we de uren kunnen instellen die er op ons LCD moet komen te staan.
int day = 0;                                                                        //We gaan de variable day aanmaken zodat we de dagen kunnen instellen die er op ons LCD moet komen te staan.
int date = 0;                                                                       //We gaan de variable date aanmaken zodat we de datum kunnen instellen die er op ons LCD moet komen te staan.
int month = 0;                                                                      //We gaan de variable month aanmaken zodat we de maanden kunnen instellen die er op ons LCD moet komen te staan.
int year = 0;                                                                       //We gaan de variable year aanmaken zodat we de jaren kunnen instellen die er op ons LCD moet komen te staan.
int junk = 0;
////////////////////////////////////////////////////////////////////////////////////
DigitalOut led1(LED1, "led1");                                                      //We gaan een digitale uitgang aanroepen namelijk de eerste LED en geven deze de naam led1.
////////////////////////////////////////////////////////////////////////////////////
/* HTTP Instellingen */
EthernetNetIf eth(                                                                  //We gaan de functie van ethernet opendoen om hierin de gewenste adressen in te kunnen gaan voegen.
    IpAddr(192,168,1,2),                                                            //Ip adres toedienen waarop de MBED verbonden word.
    IpAddr(255,255,255,0),                                                          //Subnetmasker voor de MBED.
    IpAddr(192,168,1,1),                                                            //Het IP adres waarop we gaan schrijven.
    IpAddr(192,168,1,1));                                                           //Het IP adres waarvan we gaan lezen.
    HTTPServer svr;                                                                 // Opstarten van de HTTP server met de bovenliggende eigenschappen.
/* END HTTP */
////////////////////////////////////////////////////////////////////////////////////
void Hoger(void) {                                                                  //Interrupt voor de ingestelde waarde hoger te zetten a.d.h.v. een drukknop.
  flaginstellen = 1;                                                                //Vlag voor instellen op 1 zetten, door de vlag op 1 te zetten kunnen we gaan instellen ipv het programma te runnen.
  waarde += 0.5;                                                                    //De ingestelde waarde gaan we verhogen met 0.5°C.
  counter = 0;                                                                      //We gaan de counter terug op 0 zetten, waardoor we terug 0 keer hebben gedrukt op de verhoog knop.
  wait(0.5);                                                                        //We gaan 0.5 seconden wachten voordat we verder gaan zodat we zeker zijn dat er geen twee keer is gedrukt op de verhoog knop.
}
////////////////////////////////////////////////////////////////////////////////////
void Lager(void) {                                                                  //Interrupt voor de ingestelde waarde lager te zetten a.d.h.v. een drukknop.
  flaginstellen = 1;                                                                //Vlag voor instellen op 1 zetten, door de vlag op 1 te zetten kunnen we gaan instellen ipv het programma te runnen.
  waarde -= 0.5;                                                                    //De ingestelde waarde gaan we verlagen met 0.5°C.
  counter = 0;                                                                      //We gaan de counter terug op 0 zetten, waardoor we terug 0 keer hebben gedrukt op de verhoog knop.
  wait(0.5);                                                                        //We gaan 0.5 seconden wachten voordat we verder gaan zodat we zeker zijn dat er geen twee keer is gedrukt op de verhoog knop.
}
////////////////////////////////////////////////////////////////////////////////////
void AanUit(void) {                                                                 //Interrupt voor de aan/uit knop.
  if(aanuit == 0)                                                                   //Als de aanuit knop gelijk is aan gedrukt dan gaan we de volgende code uitvoeren.
  {  
    aanuit = 1;                                                                     //We gaan de variable aanuit terug op 1 zetten na het drukken van de knop, hierdoor doen we dit omdat anders we nooit de toestand van deze knop kunnen veranderen.
    lcd.cls();                                                                      //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
    lcd.printf("Opstarten...");                                                     //We gaan het op LCD de tekst met opstarten.... laten tonen om aan te geven dat we ons systeem hebben opgezet met het drukken op de aan/uit knop
    motorout = (90 * 0.000511 + 0.026);                                             //Motor op 90 graden zetten, dit is de begin toestand.
    temp1 = (LM35_1 * 3.22*100);                                                    // omvormen van analoge waarde naar graden celcius
    afronden = 2*temp1;                                                             //We gaan de temperatuur maal 2 doen.
    afronden = rint(afronden);                                                      //Hierna gaan we het getal afronden, door het getal te vermenigvuldigen met 2 kunnen we beter afronden.
    waarde = afronden/2;                                                            //Temperatuur afronden op 0.5graden
    wait(2);                                                                        //Hierna gaan we 2s wachten zodat de MBED alles juist kan instellen en zodat we op het LCD te zien krijgen dat ons programma opstart.
}
   else                                                                             //Als de toestand van de variable gelijk is aan 0, dan voeren we de code van hieronder uit.
   {
    aanuit = 0;                                                                     //We gaan de variable terug op 0 instellen waardoor we terug de variable op 1 kunnen zetten indien we het programma terug willen opstarten.
    lcd.cls();                                                                      //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
    lcd.printf("Uitschakelen...");                                                  //We gaan het op LCD de tekst met uitschakelen.... laten tonen om aan te geven dat we ons systeem hebben uitgezet met het drukken op de aan/uit knop
    motorout = (90 * 0.000511 + 0.026);                                             //Motor op 90 graden zetten, dit is de begin toestand.
    wait(2);                                                                        //Hierna gaan we 2s wachten zodat de MBED alles juist kan instellen en zodat we op het LCD te zien krijgen dat ons programma opstart.
    }
}
////////////////////////////////////////////////////////////////////////////////////      
void temperatuurinlezen(void) {                                                     //Interrupt voor de temperatuur inlezen.
    temp1 = (LM35_1 * 3.22*100);                                                    // omvormen van analoge waarde naar graden celcius
    afronden = 2*temp1;                                                             //We gaan de temperatuur maal 2 doen.
    afronden = rint(afronden);                                                      //Hierna gaan we het getal afronden, door het getal te vermenigvuldigen met 2 kunnen we beter afronden.
    temp1 = afronden/2;                                                             //Temperatuur afronden op 0.5graden
    temp2 = (LM35_2 * 3.22*100);                                                    // omvormen van analoge waarde naar graden celcius                                                      
    afronden = 2*temp2;                                                             //We gaan de temperatuur maal 2 doen
    afronden = rint(afronden);                                                      //Hierna gaan we het getal afronden, door het getal te vermenigvuldigen met 2 kunnen we beter afronden.
    temp2 = afronden/2;                                                             //Temperatuur afronden op 0.5graden
}      
////////////////////////////////////////////////////////////////////////////////////    
void temperatuuruitsturen(void) {                                                   //Interrupt voor de temperatuur uitlezen.
   if(temp1 > (waarde + 1)) {                                                       //Als de waarde van de eerste LM35 hoger is als de ingestelde waarde
    LEDJE1 = 1;                                                                     // Lamp1 op breadboard aan "Groen".
    LEDJE2 = 0;                                                                     // Lamp2 op breadboard uit"Rood".
    lcd.cls();                                                                      //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
    lcd.printf("BIN: %5.2f C",temp1);                                               //Temperatuur binnen op LCD
    lcd.locate(0,1);                                                                //We gaan ons eigen op de juiste lijn van het LCD zetten, namelijk op de tweede lijn.
    lcd.printf("BUI: %5.2f C",temp2);                                               //Temperatuur buiten op LCD
    wait(0.3);                                                                      //Wachttijd                                                         
    relais = 0;                                                                     //We gaan de relais op 0 zetten waardoor deze uitschakelt en het bijhorend LEDJE gaat doven.
}
   else if(temp1 <= (waarde - 1) ) {                                                //Als de waarde van de eerste LM35 lager is als de ingestelde waarde
    LEDJE1 = 0;                                                                     // Lamp1 op breadboard uit "Groen".
    LEDJE2 = 1;                                                                     // Lamp2 op breadboard aan "Rood".
    lcd.cls();                                                                      //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
    lcd.printf("BIN: %5.2f C",temp1);                                               //Temperatuur binnen op LCD
    lcd.locate(0,1);                                                                //We gaan ons eigen op de juiste lijn van het LCD zetten, namelijk op de tweede lijn.
    lcd.printf("BUI: %5.2f C",temp2);                                               //Temperatuur buiten op LCD
    wait(0.3);                                                                      //Wachttijd                                           
    relais = 1;                                                                     //We gaan de relais op 1 zetten waardoor deze inschakelt en het bijhorend LEDJE gaat aangaan.
   }
}
//////////////////////////////////////////////////////////////////////////////////// 
void motor(float graden) {                                                          //Interrupt voor de toestand van de servo-motor.
   if ( (graden > 20) && (graden < 160) ) {                                         //Als de ingegeven graden groter is als de begin waarde en alsook kleiner is als de grootste waarde dan de code van hieronder uitoeren.
    motorout = (graden * 0.000511 + 0.026);                                         //We gaan de motor laten draaien naar de gewenste graden die afhankelijk is van het temperatuurverschil.
   }
   else if (graden >= 160){                                                         //Als het temperatuur verschil groter word als 160° dan gaan we de motor op zijn laatste positie namelijk 160° laten staan waardoor we zien dat we een maximaal temperatuurverschil hebben.
    motorout = (160 * 0.000511 + 0.026);                                            //Beveiliging => niet boven 160graden
   }
   else {
    motorout = (20 * 0.000511 + 0.026);                                             //Beveiliging => niet onder 20 graden
   }
   return;
}
////////////////////////////////////////////////////////////////////////////////////    
void initHTTP(void) {                                                               //Interrupt voor het HTTP protocol.
    printf("Start initialisatie HTTP\r\n");                                         //We gaan op het LCD schrijven dat we bezigz zijn met de intialisering van het LCD
    EthernetErr ethErr;                                                             //Error variabele aanmaken                                                      
    int count = 0;
    do {
        printf("Setting up %d...\n\r", ++count);
        ethErr = eth.setup();                                                       //Ethernet poort starten, variabele toekennen aan de setup
        if (ethErr) printf("Timeout\n\r", ethErr);                                  //Als er een fout is timeout geven
    } 
    while (ethErr != ETH_OK);                                                       //Zolang er geen fout is
    printf("Connected OK\n\r");
    const char* hwAddr = eth.getHwAddr();                                           //Adres krijgen
    IpAddr ethIp = eth.getIp();                                                     //Ip adres opvragen
    printf("IP address : %d.%d.%d.%d\n\r", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);
    svr.addHandler<SimpleHandler>("/hello");                                        //HTTPS server request handler
    svr.addHandler<FSHandler>("");                                                  //Handler voor file weg te schrijven
    svr.bind(80);                                                                   //Server binden aan poort 80
    printf("Server listening\n\r");                                                 //Laten zien dat onze server luistert, waardoor we kunnen zenden van data.
}
////////////////////////////////////////////////////////////////////////////////////    
void klokophalen() {                                                                //Interrupt voor de tijd op ons LCD te krijgen.
    my1307.gettime(&sec, &minuten, &hours, &day, &date, &month, &year);             //De tijden van de klok ophalen en laten tonen op het LCD
}
////////////////////////////////////////////////////////////////////////////////////     
void klokuitsturen() {                                                              //Interrupt voor de CLK.
    klokophalen();                                                                  //De tijden van de klok ophalen
    lcd.cls();                                                                      //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.kunt g
    lcd.locate(0,0);                                                                //Eerste lijn van het LCD
    lcd.printf("%d:%d:%d",hours,minuten,sec);                                       //Tijd op LCD zetten
    lcd.locate(0,1);                                                                //Tweede lijn van het LCD
    lcd.printf("%d/%d/%d",date,month,year);                                         //Datum op LCD zetten
}
////////////////////////////////////////////////////////////////////////////////////
void hoekverdraaiingbepalen(float verschilgraden,float temperatuurbuiten) {
float startstand;

        //Bepalen op welke stand hij staat (Waar hij op de belastingslijn is)
               if (verschilgraden < -1.5) {
                stand = -2;
                }
            else if( (-1.5 <= verschilgraden) && (verschilgraden < -0.5) ){
                stand = -1;
                }
            else if (  (-0.5 <= verschilgraden) && (verschilgraden <= 0.5) ) {
                stand = 0;
                }
            else if ( (0.5 < verschilgraden) && (verschilgraden <= 1.5) ) {
                stand = 1;
                } 
            else {
                stand = 2;
                }

    //Bepalen van belastingslijn// 
    printf("Temperatuurbuiten: %f\n\r", temperatuurbuiten); 
    if ( temperatuurbuiten < 23 ){
        startstand = 125;           //Belastingslijn 1
        printf("Temperatuurbuiten is kleiner dan -5 graden.\r\n");   
        }
    else if ( (23 <= temperatuurbuiten) && (temperatuurbuiten <= 25) ){
        startstand = 90;            //Belastingslijn 2
        printf("Temperatuurbuiten is tussen -5 en 10 graden.\r\n"); 
        } 
    else {
        startstand = 55;            //Belastingslijn 3
        printf("Temperatuurbuiten is groter dan 10 graden.\r\n"); 
        }

    //Bepalen van graden//
    hoekverdraaiing = startstand + (stand * 35); 
    if (hoekverdraaiing > 160) { //Beveiliging
        hoekverdraaiing = 160;
        }
    else if (hoekverdraaiing < 20){ //Beveiliging
        hoekverdraaiing = 20;
        }
    
    }
////////////////////////////////////////////////////////////////////////////////////
int main(void)
{
    /* START INITIALISATIE */
    knopHOGER.rise(&Hoger);                                                         //Knop hoger instellen.
    knopLAGER.rise(&Lager);                                                         //Knop lager inestellen
    aanuitknop.rise(&AanUit);                                                       //Knop aan&uit instellen
    initHTTP();                                                                     //HTTP initialiseren
    Timer tm;                                                                       //Timer selecteren
    tm.start();                                                                     //Timer starten
    /* STOP INITIALISATIE */
    while(true) {                                                                   //While lus
    if( (aanuit == 1) && (flaginstellen == 0) ) {                                   //open if functie
        temperatuurinlezen();                                                       //Inlezen van temperatuur
        temperatuuruitsturen();                                                     //Uitsturen van temperatuur
        klokophalen();                                                              //Ophalen van de klok waarde voor datum en tijd
        /* START HTTP */    
        printf("Net poll start\r\n");                                               //Printen op de Computer voor Theratherm
        Net::poll();
        if (tm.read() > 0.5) {                                                      //Open IF functie
            led1 = !led1;                                                           //Led aan of uit sturen
            tm.start();                                                             //Start timer                                               
            c++;                                                                    //Optellen zodat om de 1s de gegevens worden doorgestuurd
            }
        printf("Net poll gedaan\r\n");
        if (c==1) {                                                                 //Als we gaan zenden dan gaan we de code van hieronder uitvoeren tijdens het zenden van de data.
            printf("Ik probeer nu de file te openen..\r\n"); 
            //FILE *fp = fopen("/webfs/mydata.htm","w");
            FILE *fp = fopen("/local/Project.htm", "w");                            // Open "Test.htm" on the local file system for writing
            printf("File geopend!\r\n");                                            //Print
            fprintf(fp,"<HTML>\r\n");                                               //HTML opstarten
            fprintf(fp,"<HEAD>\r\n");                                               //Head van het bestand open zetten.
            fprintf(fp,"<script type=\"text/javascript\">window.setTimeout(function(){ document.location.reload(true); }, 3000);</script>");//Script laden  
            fprintf(fp,"<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/css/bootstrap.min.css\">");//Stijl van het document laden
            fprintf(fp,"<style>\r\n");//De style toepassen die is opgevraagd          
            fprintf(fp,"tbody {background:#FF6666;}");//Achtergrond veranderen van kleur
            fprintf(fp,"</style>\r\n");//De aangemaakt stijl terug sluiten
            fprintf(fp,"</HEAD>\r\n");//Sluiten van de HEAD
            fprintf(fp,"<BODY>\r\n");//Sluiten van de BODY
            /* TEST BOOTSTRAP */    
            fprintf(fp,"<div class=\"container\">\r\n");      
            fprintf(fp,"<div class=\"panel panel-success\">");
            fprintf(fp,"<div class=\"panel-heading\">%d:%d:%d     %d/%d/%d</div>",hours,minuten,sec,date,month,year);
            fprintf(fp,"<table class=\"table\">");//Aanmaken van tabel
            fprintf(fp,"<thead><tr><th>Temperatuur binnen</th><th>Temperatuur buiten</th></tr></thead>"); 
            fprintf(fp,"<tbody><tr><td>%.1f &deg;C</td>",temp1);//Kiezen waar we temp1 in de tabel gaan steken
            fprintf(fp,"<td>%.1f &deg;C</td></tr></tbody></table></div>",temp2);//Kiezen waar we temp2 in de tabel gaan steken.
            /* END TEST BOOTSTRAP */
            fprintf(fp,"</div>");
            printf("Variabelen printen\r\n");
            fprintf(fp,"</BODY>\r\n");
            fprintf(fp,"</HTML>\r\n");
            printf("Sessie stoppen \r\n"); 
            fclose(fp);//Stop schrijven
            printf("staat online\r\n"); 
            c=0;
           }
           /* EINDE HTTP */
        /* Motor sturing hier */
        verschilgraden = waarde - temp1;
        printf("Verschilgraden: %f\n\r", verschilgraden);
        hoekverdraaiingbepalen(verschilgraden,temp2);  
        printf("Stand: %f\n\r", stand);
        printf("Hoekverdraaiing: %f\n\r", hoekverdraaiing);   
        wait(1);                                                              
        motor(hoekverdraaiing);         //Motor aansturen               
        /* Stop motor sturing hier */
        } 
        else if( (aanuit == 1) && (flaginstellen == 1) ) {                          //open else if
            /* Programmatie instellen */
            printf("Programma instelmodus aan\r\n");
            while (counter <= 3) {
                lcd.cls();                                                          //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
                lcd.printf("BIN: %5.2f C",waarde);                                  //Printen van de binnen temp
                lcd.locate(0,1);                                                    //Tweede lijn van LCD
                lcd.printf("BUI: %5.2f C",temp2);                                   // Printen van de buiten temp
                wait(0.8);                                                          //Wachttijd
                lcd.cls();                                                          //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
                lcd.printf("");                                                     //Lcd laten flikkeren voor instellen
                lcd.locate(0,1);                                                    // Tweede lijn van het LCd
                lcd.printf("BUI: %5.2f C",temp2);                                   //Printen van de buiten temp
                wait(0.2);                                                          //Wachttijd
                counter++;                                                          //Counter incrementeren met 1
            }
            flaginstellen = 0;                                                      //Instellen stoppen
        } 
        else {                                                                      //open else
            lcd.cls();                                                              //We gaan het LCD refreshen of m.a.w. het LCD leegmaken.
            klokuitsturen();                                                        //De waarde van de klok op de LCD zetten
            printf("Staat uit\r\n");
            }                                                                       //sluit else
    }  
}