#include "mbed.h"
/* 
  Example of Program for the MonsterMoto Shield on the ST Nucleo L152RE
  Code by : Vivien Michel
  
  Based on the Arduino sketch example coded by: Jim Lindblom,  SparkFun Electronics
 
 License: CC-SA 3.0, feel free to use this code however you'd like.
 Please improve upon it! Let me know how you've made it better.
 
 This is really simple example code to get you some basic
 functionality with the MonsterMoto Shield. The MonsterMote uses
 two VNH2SP30 high-current full-bridge motor drivers.
 */

#define LOW 0
#define HIGH 1

DigitalOut statpin(D13, LOW); 

#define MAXSPEED 1.0f

#define BRAKEVCC 0
#define CW   1
#define CCW  2
#define BRAKEGND 3
#define CS_THRESHOLD 0.5f


/*  VNH2SP30 pin definitions */
DigitalOut dirA(D12, LOW);  // INA: Clockwise input
DigitalOut dirB(D13, LOW); // INB: Counter-clockwise input
PwmOut pwmLeftpin(PA_7); // PWM input
PwmOut pwmRightpin(PB_3); // PWM input
AnalogIn csLeftpin(A2); // CS: Current sense ANALOG input
AnalogIn csRightpin(A3); // CS: Current sense ANALOG input
AnalogIn enLeftpin(A0); // EN: Status of switches output (Analog pin)
AnalogIn enRightpin(A1); // EN: Status of switches output (Analog pin)


void setupShield()
{  
    pwmLeftpin.period_ms(10);
    pwmLeftpin.pulsewidth_ms(1);
    pwmLeftpin.write(0.0f);

    pwmRightpin.period_ms(10);
    pwmRightpin.pulsewidth_ms(1);  
    pwmRightpin.write(0.0f);        
}

void checkShield()
{  
  if ((csLeftpin.read_u16() < CS_THRESHOLD) && (csRightpin.read_u16() < CS_THRESHOLD))
    statpin.write(HIGH);
  else 
      statpin.write(LOW);
}


void stopLeftMotor()
{
        pwmLeftpin.write(0.0f);
}

void stopRightMotor()
{
        pwmRightpin.write(0.0f);
}

/* 
 set a motor going in a specific direction
 the motor will continue going in that direction, at that speed
 until told to do otherwise.
 
 direct: Should be between 0 and 3, with the following result
 0: Brake to VCC
 1: Clockwise
 2: CounterClockwise
 3: Brake to GND
 
BRAKEVCC 0
CW   1
CCW  2
BRAKEGND 3
 
pwm: should be a value between 0.0f and 1.0f, higher the number, the faster it'll go
 */
 
void goLeftMotor(uint8_t direct, float percent)
{
    if (direct <=4)
    {
      if (direct <=1)
        dirB.write(HIGH);
      else
        dirB.write(LOW);

        pwmLeftpin.write(percent);
    }
}
 
void goRightMotor(uint8_t direct, float percent)
{
    if (direct <=4)
    {
      if (direct <=1)
        dirA.write(HIGH);
    else
        dirA.write(LOW);
        
        pwmRightpin.write(percent);
    }
}
 

void setup()
{  
    setupShield();
}

void loop()
{
  goLeftMotor(CW, MAXSPEED);
  goRightMotor(CCW, MAXSPEED);
  //checkShield();
  wait_ms(5000);

  stopLeftMotor();
  stopRightMotor();
  //checkShield();
  wait_ms(2000);

  goLeftMotor(CCW, 255.0f);
  goRightMotor(CW, 255.0f);
  //checkShield();
  wait_ms(3000);

  stopLeftMotor();
  stopRightMotor();
  //checkShield();
  wait_ms(2000);
}

int main() {
    setup();
    while(1) {
        loop();
    }
}
 