#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include "rtos.h"

// instantiate hardware peripherals
LM75B tmpSns(p28,p27);
C12832_LCD lcd;
Serial pc(USBTX, USBRX); // tx, rx; used only if errors encountered

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

AnalogIn Pot1(p19);

typedef unsigned short potVal_t;
typedef float  tempVal_t;

//Potentiometer values memory pool
MemoryPool<potVal_t, 16> potVal_mpool;
Queue<potVal_t, 16> potVal_queue;

//Temperature sensor values memory pool
MemoryPool<tempVal_t, 16> tempVal_mpool;
Queue<tempVal_t, 16> tempVal_queue;


// Thread  potVal_send_thread()
// Pot1 sends value to LCD thread via IPC Queue
void potVal_send_thread(void const *args)
{
    potVal_t *potValMessage;

    while(true)
    {
//        potVal_t *potValMessage = potVal_mpool.alloc();
        potValMessage = potVal_mpool.alloc();
        *potValMessage = Pot1.read_u16(); // get Pot1 value
        potVal_queue.put(potValMessage);  // put it in the queue
        Thread::wait(1000);    // wait 1.0s
    }
}

// Thread  tempVal_send_thread()
// Temperature sensor sends value to LCD thread via IPC Queue
void tempVal_send_thread(void const *args)
{
    float *tempValMessage;
    while(true)
    {
//        float *tempValMessage = tempVal_mpool.alloc();
        tempValMessage = tempVal_mpool.alloc();
        *tempValMessage = ((tmpSns.read()*9/5)+32);// get Temp update
        tempVal_queue.put(tempValMessage);  // put value in the queue
        Thread::wait(1000);  // wait 0.5s
        pc.printf("\ntempVal_send_thread executing");
    }
}

void lcd_thread(void const *args) 
{   
    osEvent evt1;
    osEvent evt2;
    
    float *tempVal;
    potVal_t *pot1Val;
    
    
    while (true) 
    {
     //   osEvent evt1 = potVal_queue.get();
        evt1 = potVal_queue.get();
        if (evt1.status == osEventMessage) 
        {
            potVal_t *pot1Val = (potVal_t*)evt1.value.p;
            pot1Val = (potVal_t*)evt1.value.p;
            lcd_mutex.lock(); // exclude other thread access to lcd 
            lcd.locate(0,0);
            lcd.printf("\nPot1=%d", *pot1Val);
            lcd_mutex.unlock();
            potVal_mpool.free(pot1Val);
        }
        
      //  osEvent evt2 = tempVal_queue.get();
        evt2 = tempVal_queue.get();
        if (evt2.status == osEventMessage) 
//        pc.printf("\nevt2.status == osEventMessage");
        {
//            float *tempVal = (float*)evt2.value.p;
            tempVal = (float*)evt2.value.p;
            lcd_mutex.lock(); // exclude other thread access to lcd 
            lcd.locate(0,20);
            lcd.printf("\nTemp=%3.1f", *tempVal);
            lcd_mutex.unlock();
            tempVal_mpool.free(tempVal);
        }
        
    }
}

int main() {
    pc.printf("\nmain started...");
    lcd.cls();
    Thread thread1(potVal_send_thread);
    pc.printf("\nthree threads started...");
    Thread thread2(lcd_thread);
    Thread thread3(tempVal_send_thread);
    pc.printf("\nthree threads started...");

    while(true)
    {
        Thread::wait(1000);
    }
}

