/**
* @section LICENSE
*Copyright (c) 2010 ARM Ltd.
*
*Permission is hereby granted, free of charge, to any person obtaining a copy
*of this software and associated documentation files (the "Software"), to deal
*in the Software without restriction, including without limitation the rights
*to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
*copies of the Software, and to permit persons to whom the Software is
*furnished to do so, subject to the following conditions:
* 
*The above copyright notice and this permission notice shall be included in
*all copies or substantial portions of the Software.
* 
*THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
*OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
*THE SOFTWARE.
* 
*
* @section DESCRIPTION
*  Library for using the SCP1000-D01 MEMS Pressure sensor
*
*/

#ifndef SCP1000_D01_H_
#define SCP1000_D01_H_
/**
* Includes
*/
#include "mbed.h"
/**
* Class to allow reading of the SCP1000-D01 mems pressure sensor (SPI mode). The class currently only supports High resolution mode.
* This means that the sensor can be read at a maximum rate of 1.8Hz.
*/
class SCP1000{
public:               
    /**
    *Constructor 
    * 
    * @param mosi The MOSI pin for the SPI interface
    * @param miso The MISO pin for the SPI interface
    * @param CSB The Chip select on the SCP1000
    */
    SCP1000(PinName mosi, PinName miso, PinName sck, PinName CSB);

    /**
    * Read the current Pressure.
    * This blocks until the sensor has completed a reading
    * 
    * @returns The pressure in pascals (N/m2)
    */
    float read();
    /**
    * Reads the temperature as measured by the SCP1000.
    * This blocks until the sensor has completed a reading
    *
    *@returns The temperature in degrees celsius
    */
    float readTemperature();
    
    

private:
    /**
    * Method which blocks until the sensor is ready to be read.
    * @returns 1 when successful.
    */
    int _waitReady();
    //Interfaces
    SPI _spi;
    DigitalOut _CSB;
    
    //Pins that woudl be required to use SCP1000 in different modes
   // DigitalIn _DRDY;    //Interrupt data ready - also need to be able to attach a function to this class
   // DigitalOut _TRIG;   //Trigger        
   // DigitalOut _PD;     //Power Down


};
#endif