/**
Copyright (c) 2010 ARM Ltd
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "RPCVariable.h"
#include "SerialRPCInterface.h"
#include "ADJDColourSensor.h"
#include "TMP102.h"
#include "scp1000.h"
LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;

void getColour(char * input, char * Output);
void getTemperature(char *input, char * Output);
void getPressure(char *input, char * Output);
void getSCPTemperature(char *input, char * Output);

//Set up sensors
TMP102 Temperature(p9, p10, 0x90);
ADJDColourSensor Colour(p28,p27, p22);
SCP1000 Pressure(p5,p6,p7,p8);
DigitalIn PIR(p21, "PIR");
AnalogIn Light(p20, "Light");

//Set up custom RPC
RPCFunction GetTemp(&getTemperature, "Temperature");
RPCFunction GetPressure(&getPressure, "Pressure");
RPCFunction GetSCPTemperature(&getSCPTemperature, "SCPtemperature");
RPCFunction GetColour(&getColour, "Colour");
 
//Serial RPC used for testing 
//SerialRPCInterface applet(USBTX, USBRX, 115200);


int main() {
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");
  //Listen indefinitely
  while(true){
     Net::poll();
    //Do own thing here
    
    //This could for example be data logging.
        
  }
  
}

//RPC Functions  - these are used to wrap the sensor libraries that other wise would not be acessible over RPC.
void getTemperature(char *input, char * Output){
    float f = Temperature.read();
    sprintf(Output, "%f", f);
}
void getPressure(char *input, char * Output){
    float f = Pressure.read();
    sprintf(Output, "%f",f);
}
void getSCPTemperature(char *input, char * Output){
    float f = Pressure.readTemperature();
    sprintf(Output, "%f", f);
}
void getColour(char *input, char * Output){
    float clear = Colour.read();
    sprintf(Output, "%f,%f,%f,%f,", clear/500, Colour.red/500, Colour.green/500, Colour.blue/500);
}