/**
* Copyright (c)2010 ARM Ltd.
* Released under the MIT License: http://mbed.org/license/mit
*/
#include "mbed.h"
#include "SerialRPCInterface.h"
#include "SRF08.h"

using namespace mbed;

//Create the interface on the USB Serial Port
SerialRPCInterface RPC(USBTX, USBRX);
void ReadRange(char * input, char * output);
RPCFunction RangeFinder(&ReadRange, "RangeFinder");
SRF08 srf08(p9, p10, 0xE0);      // Define SDA, SCL pin and I2C address 
DigitalOut myled(LED1);

int main() {

    while(1) {
        
    
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

//As neither I2C nor the SRF08 library is avalible directly over RPC we create a Custom Function which we make RPCable by attaching to an RPCFunction
void ReadRange(char * input, char * output){
    //Format the output of the srf08 into the output string
    sprintf(output, "%f", srf08.read());
}
