/**
* Copyright (c)2010 ARM Ltd.
* Released under the MIT License: http://mbed.org/license/mit
*/

#include "mbed.h"
#include "QEI.h"
#include "Motor.h"
#include "SerialRPCInterface.h"

//Create the interface on the USB Serial Port
SerialRPCInterface SerialInterface(USBTX, USBRX);

QEI Encoder(p29 ,p30, NC, 48);
Motor Wheel(p23, p21, p22);

//Create float variables
float MotorOutput = 50;
float Percentage = 0;

//Make these variables accessible over RPC by attaching them to an RPCVariable
RPCVariable<float> RPCMotorOut(&MotorOutput, "MotorOutput");
RPCVariable<float> RPCPercentage(&Percentage, "Percentage");

int main(){

    Encoder.reset();
    float NoPulses;
    
    while(1){ 
         NoPulses = Encoder.getPulses();
        Percentage = ((NoPulses / 48) * 100);
        //RPC will be used to set the value of MotorOutput.
        Wheel.speed((MotorOutput - 50) * 2 / 100);
        wait(0.005);
    }
}