#include "mbed.h"
#include "WakeUp.h"

DigitalOut myled(LED1);

void ClearWakeUp(void);

int main()
{
    myled = 1;
    wait(0.2);
    myled = 0;
    wait(0.2);

    //The low-power oscillator can be quite inaccurate on some targets
    //this function calibrates it against the main clock
    WakeUp::calibrate();


    WakeUp::set_ms(5000);
    ClearWakeUp();

    printf("Entering Standby Mode\r\n");

    HAL_PWR_EnterSTANDBYMode();
    
    //This will never be executed
    printf("After sleep\r\n");

}
void ClearWakeUp(void)
{
    PWR->CR |= PWR_CR_DBP;      //Enable power domain
    RTC->WPR = 0xCA;            //Disable RTC write protection
    RTC->WPR = 0x53;

    __HAL_PWR_CLEAR_FLAG(PWR_FLAG_WU);
    __HAL_PWR_CLEAR_FLAG(PWR_FLAG_SB);

    RTC->WPR = 0xFF;        //Enable RTC write protection
    PWR->CR &= ~PWR_CR_DBP; //Disable power domain
}