/*
Required input format
For Temps:
temp GPU:55 CPU:45 SYS:35


numbers MUST be two digit, 01-99, anything over 99 is shown as 99.
*/


#include "mbed.h"
#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 512            // Setting to default so it can be referenced/changed later
#include "MODSERIAL.h"
#include "SPI_TFT.h"
#include "Arial12x12.h"
#include "Arial28x28.h"
#include "touch_tft.h"

DigitalOut myled(LED1);

//Serial Variables
MODSERIAL pc(USBTX, USBRX); // tx, rx
bool newline_detected = false;
char messageBufferIncoming[MODSERIAL_DEFAULT_RX_BUFFER_SIZE];

//Screen Variables
touch_tft tt(p19,p20,p16,p17,p11, p12, p13, p14, p15,"TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs, reset

//Other Program Variables
const int GraphWidth = 320;
const int ScreenWidth = 295;
const int ScreenHeight = 195;
uint8_t GPUtemp[GraphWidth] = { 0 };
uint8_t CPUtemp[GraphWidth] = { 0 };
uint8_t SYStemp[GraphWidth] = { 0 };

int currentGPUtemp = 0;
int currentCPUtemp = 0;
int currentSYStemp = 0;
int GraphLocation = GraphWidth;

int i;

void rxCallback(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *serial = q->serial;
    if ( serial->rxGetLastChar() == '\n') {
        newline_detected = true;
    }
}

void AddNewTemp(int inGPUtemp, int inCPUtemp, int inSYStemp) {
    GPUtemp[GraphWidth - 1] = inGPUtemp;
    CPUtemp[GraphWidth - 1] = inCPUtemp;
    SYStemp[GraphWidth - 1] = inSYStemp;
}

void MoveOnGraph(void) {
    for(i = 0; i < GraphWidth; i++) {
    GPUtemp[i] = GPUtemp[i + 1];
    CPUtemp[i] = CPUtemp[i + 1];
    SYStemp[i] = SYStemp[i + 1];    
    }
}

void setTemps(char* inTemps) {
    char temp1[3];
    char temp2[3];
    char temp3[3];
    temp1[0] = inTemps[9];
    temp1[1] = inTemps[10];
    temp1[2] = '\0';
    temp2[0] = inTemps[16];
    temp2[1] = inTemps[17];
    temp1[2] = '\0';
    temp3[0] = inTemps[23];
    temp3[1] = inTemps[24];
    temp1[2] = '\0';
    AddNewTemp(atoi(temp1), atoi(temp2), atoi(temp3));             
}

void DrawGraphOutline(void) {
    tt.line(0,220,319,220,White);               // Graph Line Across
    tt.line(25,25,25,239,White);                // Graph Line Down  
    
    tt.locate(3,3);
    printf("Temps");
    
    tt.locate(260,222);                         // X axis labels
    printf("1");    
    tt.locate(200,222);
    printf("2");    
    tt.locate(140,222);
    printf("3");    
    tt.locate(80,222);
    printf("4");
    
    tt.locate(1,170);                         // Y axis labels
    printf("25");    
    tt.locate(1,120);
    printf("50");
    tt.locate(1,70);
    printf("75");

}

void DrawGraph(void) {   
    int pix;
    int tempDiff;
    int width = GraphWidth - ScreenWidth;
    for(pix = GraphWidth; pix > width ; pix--){
        if((GPUtemp[pix] > 0)/* && (GPUtemp[pix - 1] != GPUtemp[pix])*/){
            if(GPUtemp[pix -1] > 0){tt.pixel(pix, 220 - (GPUtemp[pix - 1] * 2), Black);}
            tt.pixel(pix, 220 - (GPUtemp[pix] * 2), Green);
            }
        if((CPUtemp[pix] > 0)/* && (CPUtemp[pix - 1] != CPUtemp[pix])*/){
            if(CPUtemp[pix -1] > 0){tt.pixel(pix, 220 - (CPUtemp[pix - 1] * 2), Black);}
            tt.pixel(pix, 220 - (CPUtemp[pix] * 2), Blue);
            }
        if((SYStemp[pix] > 0) /*&& (SYStemp[pix - 1] != SYStemp[pix])*/){
            if(SYStemp[pix -1] > 0){tt.pixel(pix, 220 - (SYStemp[pix - 1] * 2), Black);}
            tt.pixel(pix, 220 - (SYStemp[pix] * 2), Red);
            }
    }
    tt.locate(30,30);                         
    printf("GPU: %i", GPUtemp[GraphWidth - 1]);    
    tt.locate(30,45);
    printf("CPU: %i", CPUtemp[GraphWidth - 1]);    
    tt.locate(30,60);
    printf("SYS: %i", SYStemp[GraphWidth - 1]);    
}

int main() {
    pc.attach(&rxCallback, MODSERIAL::RxIrq);   //Setup USB Serial connection
    
    tt.claim(stdout);                           // send stdout to the TFT display
    tt.background(Black);                       // set background to black
    tt.foreground(White);                       // set chars to white
    tt.cls();                                   // clear the screen
    tt.set_font((unsigned char*) Arial12x12);   // select the font
    tt.set_orientation(1);
    
    tt.line(0,25,319,25,White);                 // Line Across
    tt.line(80,0,80,24,White);                  // Line Down 1
    tt.line(160,0,160,24,White);                // Line Down 2 
    tt.line(240,0,240,24,White);                // Line Down 3
    
    DrawGraphOutline();    
    
    while(1) {
        while (! newline_detected ) ;
        pc.move(messageBufferIncoming, MODSERIAL_DEFAULT_RX_BUFFER_SIZE);
        newline_detected = false;
        if(strncmp(messageBufferIncoming,"temp",4) == 0) {
            setTemps(messageBufferIncoming);
            DrawGraph();
            MoveOnGraph();
        }
    }
}