#include "mbed.h"
#include <stdio.h>

PwmOut ledazul (LED2);   //Salida Pwm
AnalogIn input(PTC2);    //Entrada potenciometro
Serial GSM(PTE0,PTE1);   //puertos del FRDM para el modem
Serial pc(USBTX,USBRX);  //Comunicacion PC

int med,num,i,j,k,C,A;
float B=0,ciclo=0,periodo=0;

int main(void)
       { 
       
       GSM.baud(9600);         // asigno baudios y configuro puerto serie de la usart
       GSM.format(8,Serial::None,1); 
               
       while(1){ 
                              //leer el puerto analógico
       wait(0.5);
       num = input*1000;      //se escala el numero 
           //pc.printf("num=%d\n", num);

       if(num<256){          //debo generar dos casos a APP inventor solo me recibe hex asi: 0xhhhh (4 cifras)    
           GSM.putc(0);      //si el número es hasta 255 se le ponen dos ceros adelante a la secuencia de bits
           GSM.putc(i);      //luego la cifra menos significativa
       }
       if(num>255){          //pero si es mayor a 255 las cifras deben ser convertidas a un hex de dos bytes de la siguiente forma   
           j=num/256;        //calculo la cifra mas significativa
           k=num-j*256;      //calculo la cifra menos significativa
           GSM.putc(j);      //las envío a la usart para que se las ponga al modulo bluetooth y la lleve al android
           GSM.putc(k);      //mas significativa primero, menos después si no no funciona!!! y con la orden PUTC solo asi le envia binarios
    
       }
        //capturo los datos del cel
       if (GSM.readable())
       {    
            
            A = GSM.getc(); //Leo el valor del slider;
            pc.printf("%i\n\r", A);
            
             if (A <101) {      //if para el ciclo de trabajo. Se tiene en cuenta solo hasta 100 puesto que en el App Inventor, el slider del ciclo de trabajo va de 0 a 100
                ciclo=A/100.0; //calculo el ciclo de trabajo
                ledazul.write(ciclo); //ingreso a la salida el ciclo del trabajo
                pc.printf("Ciclo de Dureza: %f\n\r", ciclo);
                
            }

            if (A >101) {   //if para el periodo. Es mayor a 100 porque en App Inventor el slider del periodo va de 100 a 200.
                B=A;        //Se asigna otra variable para no entrar en conflicto con la anterior
                periodo=((B-100.0))/100; //Calculo el periodo
                ledazul.period (periodo);  //ingreso a la salida el periodo

                pc.printf("Periodo: %f\n\r", periodo);
                
            }      
 
        }
}
}       