#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h" 
#include "QEI.h"
 
Rtc_Ds1307 rtc(PTE0,PTE1);        //Puertos para el modulo
Serial pc(USBTX, USBRX, "pc");    //Puertos para el PC
QEI wheel (PTD5, PTD0, NC, 100);  //Configuracion encoder
DebouncedIn Boton(PTA13);        //Boton Encoder
DigitalOut myled(LED1);
int dia=0,mes=0,ano=2015,hh=0,mm=0,ss=0;
 
char buffer[128];
int readptr = 0;
 
int main() {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        
        
       
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("La hora actual es: %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("La fecha actual es: %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            //  perform write
            pc.printf("Dia (0..31)");
            pc.scanf("%d", &tm.date);
            pc.printf("Mes (1..12)");
            pc.scanf("%d", &tm.mon);
            pc.printf("Anno");
            pc.scanf("%d", &tm.year);
            pc.printf("Hora (0..23)");
            pc.scanf("%d", &tm.hour);
            pc.printf("Minutos (0..59)");
            pc.scanf("%d", &tm.min);
            pc.printf("Segundos (0..59)");
            pc.scanf("%d", &tm.sec);
            pc.printf("Performing write operation\n");
            
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            readptr = 0;
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();
            goto set_alarma;
            
            
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        //pc.printf("\n\n\n");
        }
        
        
        set_alarma:          //Configuracion Alarma
        pc.printf("******* Configuracion Alarma *******\n");
        
        
        set_dia:             //Configuracion del Dia para la alarma
        while(1){
         
            dia=dia+wheel.getPulses();  //Aumentar el dia con el encoder
            wheel.reset();
     
            if(dia>=31){               //Si es mayor a 31, mantener en 31
                dia=31;
            }
            else if (dia<=0){          //Si es menor a 0, mantener en 0
             dia=0;
            }
     pc.printf("Dia=%d\n",dia);        //Imprimir el Dia
    
    
    if(Boton.falling()){              //Si el boton es presionado, pasar a mes
        goto set_mes;
        }

    }
        
        set_mes:                           //Configuracion del Mes para la alarma

        while(1){
         
            mes=mes+wheel.getPulses();     //Aumentar Mes con el encoder

            wheel.reset();
            
     
            if(mes>=12){                   //Si es mayor a 12, mantener en 12

                mes=12;
            }
            else if (mes<=0){              //Si es menor a 0, mantener en 0

             mes=0;
            }
     pc.printf(" Mes=%d\n ",mes);          //Imprimir el Mes

    
    
    if(Boton.falling()){
        goto set_ano;
    }
    
            
    }
     set_ano:
        while(1){
         
            ano=ano+wheel.getPulses();
            wheel.reset();
 
     
            if(ano>=3000){
                ano=3000;
            }
            else if (ano<=2015){
             ano=2015;
            }
     pc.printf(" Anno=%d\n ",ano);
    
    
    if(Boton.falling()){
        goto set_hh;
    }
        
    }
    set_hh:
        while(1){
         
            hh=hh+wheel.getPulses();
            wheel.reset();
        
     
            if(hh>=23){
                hh=23;
            }
            else if (hh<=0){
             hh=0;
            }
     pc.printf(" Hora=%d\n ",hh);
    
    
    if(Boton.falling()){
        goto set_mm;
    }
            
            
    }
     set_mm:
        while(1){
         
            mm=mm+wheel.getPulses();
            wheel.reset();
     
     
            if(mm>=59){
                mm=59;
            }
            else if (hh<=0){
             mm=0;
            }
     pc.printf(" Min=%d\n ",mm);
    
    
    if(Boton.falling()){
        goto set_comp;
    }
   
    }
    
   
    set_comp:
    
    pc.printf("***La alarma se programara el:****\n");
    pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    while(1){
       rtc.getTime(tm);
       pc.printf("La hora actual es: %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       pc.printf("La fecha actual es: %02d/%02d/%04d\n", tm.mon, tm.date, tm.year);
    if(tm.hour>=hh && tm.min>=mm &&tm.sec>=ss && tm.mon>=mes && tm.date>=dia && tm.year>=ano){
        myled=0;
    }
    else {
        myled=1;
        }
        wait(1);
    }
    
     
    }
 
 