#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "MTSSerial.h"
#include <string>
#include <vector>
#include <algorithm>
#include <sstream>
#include <iomanip>
//#include "PulseCounter.h"

// these options must match the settings on your Conduit
// uncomment the following lines and edit their values to match your configuration
static std::string config_network_name = "campbellsci";
static std::string config_network_pass = "campbellsci";
static uint8_t config_frequency_sub_band = 1;

DigitalOut greenLed(PA_11); // To turn the join LED on/off

std::string VectorInt8_To_StrHex (const vector<uint8_t>& v)
{
    stringstream ss;
    ss << std::hex << std::setfill('0');
    vector<uint8_t>::const_iterator it;

    for (it = v.begin(); it != v.end(); it++) {
        ss << ":" << std::setw(2) << static_cast<unsigned>(*it);
    }
    return ss.str();
}

std::string VectorInt32_To_StrDec (const vector<uint32_t>& v)
{
    // Serial output for debugging
    //mts::MTSSerial serial(XBEE_DOUT, XBEE_DIN, 512, 512);
    //serial.baud(115200);
    //mts::MTSSerial& _serial(serial);
    stringstream ss;
    // Body
    ss << std::dec << std::setfill('0');
    vector<uint32_t>::const_iterator it;

    for (it = v.begin(); it != v.end(); it++) {
        ss << ":" << std::setw(3) << static_cast<unsigned>(*it);
        //_serial.writef(static_cast<unsigned>(*it));
    }
    return ss.str();
}

std::string VectorMdotFile_To_List (const vector<mDot::mdot_file>& v)
{
    // Serial output for debugging
    mts::MTSSerial serial(XBEE_DOUT, XBEE_DIN, 512, 512);
    serial.baud(115200);
    mts::MTSSerial& _serial(serial);

    stringstream ss;
    vector<mDot::mdot_file>::const_iterator it;

    _serial.writef(" DEBUG: Vector size for user files list %d\r\n" , v.size());

    for (it = v.begin(); it != v.end(); it++) {
        ss << (*it).name << " " ;
    }
    return ss.str();
}

int main()
{
    greenLed = 0;
    AnalogIn in(PB_1); // Read Analog

    int32_t ret;
    mDot* dot;
    std::vector<uint8_t> data;
    //std::string data_str = "hello!";
    
    std::ostringstream ss;
    std::string data_str = "Hello";
    //ss << in.read_u16();
    //data_str = ss.str();

    // get a mDot handle
    dot = mDot::getInstance();

    // This section is to enable the debuging info over serial (rs232)
    mts::MTSSerial serial(XBEE_DOUT, XBEE_DIN, 512, 512);
    serial.baud(115200);
    mts::MTSSerial& _serial(serial);
    // Hello world
    _serial.writef("\r\n\r\n\r\n\r\n");
    _serial.writef("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ \r\n");
    _serial.writef("+                          Hello mDot                                         + \r\n");
    _serial.writef("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ \r\n");



    // print library version information
    _serial.writef("INFO: version: %s\r\n", dot->getId().c_str());

    //*******************************************
    // configuration
    //*******************************************
    // reset to default config so we know what state we're in
    dot->resetConfig();

    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()

    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels
    _serial.writef("INFO: setting frequency sub band: %d\r\n", config_frequency_sub_band);
    if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to set frequency sub band %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }

    /* Dont' need network name when setting it network EUI
        _serial.writef("INFO: setting network name: %s\r\n", config_network_name.c_str());
        if ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
            _serial.writef("ERROR: failed to set network name %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
        }
    */
    // Initializing a vecotr in C++
    // This compiler doesn't accept -> static std::vector<uint8_t> config_network_key {00,00,00,00,00,00,00,01};
    static std::uint8_t netId[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01};
    static std::vector<uint8_t> netIdV(&netId[0], &netId[0] + 8); // It is +8 since 8 members. You need start and end of the array.
    _serial.writef("INFO: setting network ID (EUI): %s\r\n", VectorInt8_To_StrHex(netIdV));
    if ((ret = dot->setNetworkId(netIdV)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to set network ID %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }
    /*
        _serial.writef("INFO: setting network password: %s\r\n", config_network_pass.c_str());
        if ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
            _serial.writef("ERROR: failed to set network password %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
        }
    */
    // Initializing a vecotr in C++
    static std::uint8_t netKey[16] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01};
    static std::vector<uint8_t> netKeyV(&netKey[0], &netKey[0] + 16); // It is +16 since 16 members. You need start and end of the array.
    _serial.writef("INFO: setting network key: %s\r\n", VectorInt8_To_StrHex(netKeyV));
    if ((ret = dot->setNetworkKey(netKeyV)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to set network key %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }

    bool adrStatus = false;
    _serial.writef("ADR Status is  %d\r\n", (*dot).getAdr());
    _serial.writef("INFO: setting Adr %d: \r\n", adrStatus);
    if ((ret = dot->setAdr(adrStatus)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to set ADR %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    } else {
        _serial.writef("Data Rate: %d\r\n", (*dot).getTxDataRate());
        _serial.writef("ADR Status is %d\r\n", (*dot).getAdr());

    }

    /*
    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    _serial.writef("INFO: setting TX data rate: ");
    if ((ret = dot->setTxDataRate(mDot::DR2)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to set TX datarate %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    } else
        _serial.writef("%d\r\n", (*dot).getTxDataRate());

    */


    // request receive confirmation of packets from the gateway
    _serial.writef("INFO: enabling ACKs\r\n");
    if ((ret = dot->setAck(1)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to enable ACKs %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // Public Network Mode
    _serial.writef("INFO: Public network state:  %d\r\n", (*dot).getPublicNetwork());
    _serial.writef("INFO: enabling Public network mode\r\n");
    if ((ret = dot->setPublicNetwork(1)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to enable Public Mode %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }
    _serial.writef("INFO: Public network state:  %d\r\n", (*dot).getPublicNetwork());


    _serial.writef("INFO: frequency band:  %s\r\n", mDot::FrequencyBandStr((*dot).getFrequencyBand()).c_str());
    _serial.writef("INFO: frequency band:  %d\r\n", (*dot).getFrequencyBand());


    const uint8_t _freqBand = 2;
    _serial.writef("INFO: Setting frequency band to:  %s\r\n", mDot::FrequencyBandStr(_freqBand).c_str());
    if ((ret = dot->setFrequencyBand(_freqBand)) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to enable Public Mode %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // Workaround to lock the TX frequencies to a single Aussie one while working with the incorrect library.
    // The latest library has the fixed 8 Aussie libraries and it makes the following  lines irrelevent.
    //_serial.writef("INFO: Setting TX frequency to:  %s\r\n", mDot::FrequencyBandStr(_freqBand).c_str());
    //if ((ret = dot->setTxFrequency(915200000)) != mDot::MDOT_OK) {
    //    _serial.writef("ERROR: failed to Set TX frequency %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    //}
    //_serial.writef("INFO: TX frequency:  %d\r\n", (*dot).getTxFrequency());


    // save this configuration to the mDot's NVM
    _serial.writef("INFO: saving config\r\n");
    if (! dot->saveConfig()) {
        _serial.writef("ERROR: failed to save configuration\r\n");
    }

    //*******************************************
    // end of configuration
    //*******************************************

    _serial.writef("INFO: frequency band:  %s\r\n", mDot::FrequencyBandStr((*dot).getFrequencyBand()).c_str());

    _serial.writef("INFO: Device ID%s\r\n", VectorInt8_To_StrHex((*dot).getDeviceId()).c_str());

    _serial.writef("INFO: Network  ID%s\r\n", VectorInt8_To_StrHex((*dot).getNetworkId()).c_str());
    _serial.writef("INFO: Network Key%s\r\n", VectorInt8_To_StrHex((*dot).getNetworkKey()).c_str());

    _serial.writef("INFO: Join mode:  %s\r\n",      mDot::JoinModeStr((*dot).getJoinMode()).c_str());

    _serial.writef("INFO: List of channel frequencies currently in use%s\r\n", VectorInt32_To_StrDec((*dot).getChannels()).c_str());
    // TODO: These data rate lists don't make sense.
    _serial.writef("INFO: List of channel datarate ranges currently in use%s\r\n", VectorInt8_To_StrHex((*dot).getChannelRanges()).c_str());
    //_serial.writef("INFO: List of channel frequencies in config file to be used as session defaults%s\r\n", VectorInt32_To_StrDec((*dot).getConfigChannels()));
    //_serial.writef("INFO: List of channel frequencies currently in use%s\r\n", VectorInt32_To_StrDec((*dot).getChannels()));



//_serial.writef("INFO: List user files stored in flash%s\r\n", VectorMdotFile_To_List((*dot).listUserFiles()));


//*******************************************
// end of debuging info
//*******************************************


// attempt to join the network
    _serial.writef("INFO: joining network...\r\n");
    while ((ret = dot->joinNetworkOnce()) != mDot::MDOT_OK) {
        _serial.writef("ERROR: failed to join network %d:%s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        osDelay(std::max((uint32_t)1000, (uint32_t)dot->getNextTxMs()));
    }
    greenLed = 1; // Joined Successfuly 

    mDot::rssi_stats _rssiStats;

    int err;
    while (true) {

        //format data for sending to the gateway
        for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++) {
            data.push_back((uint8_t) *it);
        }

        // send the data to the gateway
        if ((ret = dot->send(data)) != mDot::MDOT_OK) {
            _serial.writef("ERROR: failed to send\r\n", ret, mDot::getReturnCodeString(ret).c_str());
        } else {
            _serial.writef("INFO: successfully sent data to gateway ");

            _rssiStats = dot->getRssiStats();
            _serial.writef("+ RSSI values( last:%d min:%d max:%d avg:%d ) \r\n", _rssiStats.last, _rssiStats.min, _rssiStats.max, _rssiStats.avg);
        }

        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        //osDelay(std::max((uint32_t)50, (uint32_t)dot->getNextTxMs()));
        //osDelay(std::max((uint32_t)2000, (uint32_t)dot->getNextTxMs()));
        wait(1);

        ss.str("");

/*
        //int temp = dht11->readTemperature();
        if (err == 0) {
            float temp = dht.ReadTemperature(CELCIUS);
            float rh = dht.ReadHumidity();
            _serial.writef(" Temp: %f Rh: %f \r\n", temp, rh);
            ss << (temp);
            ss << ',';
            ss << rh;
        } else {
            ss.str("  :err ");
            ss << err;
        }
        */
        
        //double temp = ((in.read_u16() * 3.3) - 0.424) / 0.00625;
        double adc = in.read_u16();
        /*
        double a = 1E-12;
        double b = 9E-8;
        double temp;
        temp = (a*adc*adc*adc)-(b*adc*adc)+0.0041*adc-43.313;
        */
        double temp = 1.33536E-3*adc-2.2914E1;
        ss << (temp);

        data.clear();
        // Converting int to string in C++ using <sstream>
        data_str = ss.str();
    }

    return 0;
}
