#include "mbed.h"
 
I2C i2c(p9,p10);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial pc(USBTX, USBRX);
Serial device(p13, p14);

// Useful constant
const int radtodeg = (180/3.1416);
const int addr = 0x3A;
void angleMath(double, double, double);

int main() {
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    char cmd[6];
    char add[1];
    char init[2];
    add[0] = 0x01;
    init[0] = 0x2A;
    init[1] = 0x01;
    int number=0;
    i2c.frequency(40000);
 
    wait(0.5);
    //init
    //set active mode    
    while(i2c.write(addr,init,2));
    led1 = 1;
    led2 = 1;
    led3 = 1;
    
    //get analog data
    while(1) {
        //send procedure
        wait(0.07);
        switch(number){
        case 0:
            if(i2c.write(addr,add,1) == 0){
                number++;
                led1 = 1;
            }else{
                number=0;
                led1 = 0;
                led2 = 0;
                led3 = 1;
            }
            break;
        case 1:
            if(i2c.read(addr,cmd,6) == 0){
                number++;
                led2 = 1;
            }else{
                number=0;
                led1 = 0;
                led2 = 0;
                led3 = 0;
            }
            break;    
        case 2:
            //get analog data
            angleMath(cmd[1],cmd[3],cmd[5]);
                        
            led3 = 1;
            wait(0.5);
            led1 = 0;
            led2 = 0;
            led3 = 0;
            number=0;
            break;
        }
    }
}

void angleMath(double x, double y, double z){
    long double anglez, anglex,angley;
    int final;
    //angle Z
    if (z>0x7F) {
        z=(z-256)*-1;
    }
    anglez = acos(z/65)*radtodeg;
    
    //angle Y
    if (y>0x7F) {
        y=(y-256)*-1;
    }
    angley = asin(y/64)*radtodeg;
    
    // angle X
    if (x>0x7F) {
        x=(x-256)*-1;
    }
    anglex = asin(x/65)*radtodeg;
    
    // Display refresh
    device.putc(0x76);
    device.putc(0x77);
    device.putc(0x02);
    
    // Angle choice
    if(anglez < 26){
    if (anglex > angley){
            final = anglex*100;
            device.printf("%04d",final);
    } else {
            final = angley*100;
            device.printf("%04d",final);
    }
    } else {
        final = anglez*100;
            device.printf("%04d",final);
        }
    pc.printf("\rLSB OUT X = %.2f,Y = %.2f,Z = %.2f                ",anglex,angley,anglez);
}