#include "mbed.h"

#define ACC_MAX 20000   //20000 is equivalent to 1V DAC output
#define ADC_MAX 3.2 //if 5Gohm/1Mohm resistor divider is used, ADC=3.2V is equivalent to 16000kV

Ticker ADC;

DigitalOut protection_relay_D6(PB_1);
DigitalOut protection_relay_D12(PA_6);
DigitalOut zap_control_D8(PB_2);
DigitalIn turbo_D11(PA_7);
InterruptIn button_D2(PD_14);
AnalogOut aout(PA_4);
PwmOut motor_control_D10(PA_2);

unsigned acc;
AnalogIn ain(A0);

void ADC_convert()
{
    printf("%i",ain.read_u16());
}

void incr() {
    if(acc>=ACC_MAX)
        acc=ACC_MAX;
    else
    {
        if(acc<4000)
            acc+=1000;
        else if(acc<8000)
            acc+=800;
        else if(acc<10000)
            acc+=600;
        else
            acc+=500;
    }
}

int main()
{
    acc=0;
    motor_control_D10.period_ms(10);    //PWM with 50ms period
    motor_control_D10=0.2;
    button_D2.fall(&incr);
    
    protection_relay_D6=1;  //relay closed
    protection_relay_D12=1; //relay closed
    
    //ADC.attach(&ADC_convert, 0.2);  //Do ADC convertion every 200ms
    
    while(1) {
        wait(0.2); // 200 ms
        if(acc<=0)
            acc=0;
        else
            if(acc<1000)
                acc=0;
            else
                acc-=1000;
        if(turbo_D11==1)
            aout.write_u16(ACC_MAX);
        else
            aout.write_u16(acc);
        
        int ADC_reading=ain.read_u16();
        motor_control_D10=(0.2+0.8*((float)ADC_reading/65536*3.3/ADC_MAX)); //set motor speed
        if((ADC_reading/65536*3.3)>ADC_MAX) //if MAX voltage is reached
        {
            protection_relay_D6=0;  //cut off relay connection
            protection_relay_D12=0; //cut off relay connection
            wait_ms(10);    //wait 10ms for relay to disconnect completely
            zap_control_D8=1;  //ZAP!
            wait_ms(5); //wait for Zap to happen
            acc=0;
            aout.write_u16(acc);    //discharge HV generator
            zap_control_D8=0;  //disconnect CAN bus from HV generator
            wait_ms(5);
            protection_relay_D6=1;
            protection_relay_D12=1;
        }
        
        while(turbo_D11==1);    //wait until turbo button is released
            
        printf("%i\n\r", ADC_reading);  //send ADC data to GUI
    }
}
