
#include "mbed.h"
#include "SimpleBLE.h"
#include "LIS3DH.h"
#include "USBSerial.h"

//Accelerometer

#define MOSI PC_12
#define MISO PC_11
#define CS PC_5
#define SCLK PC_10

//Init simpleBLE

SimpleBLE ble("ObCP_ENSMM_CROC_test_max_beny");


// GPIO set

//Interrupt input

InterruptIn user1(PC_13);  //User1

//PWM output

PwmOut PWMoutput(PB_1);          //Main PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);                //PWM Green LED
PwmOut Blue(PC_9);               //PWM Blue LED

//USART

USBSerial pc(0x1f00, 0x2012, 0x0001, false);

//Init accelerometer

LIS3DH      acc(MOSI, MISO, SCLK, CS, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);

Timer timer;
InterruptIn event(A0);
InterruptIn button1(D3);
//DigitalOut myled(LED1);

// Characteristics Accelerometer input

SimpleChar<float> accX = ble.readOnly_float(0xA000, 0xA002);
SimpleChar<float> compteur = ble.readOnly_float(0xA000, 0xA003);
SimpleChar<float> temps = ble.readOnly_float(0xA000, 0xA004);


bool flag= false;
float begin, end;

void Pressed(){
    compteur = compteur +1;
}



// Clear the screen
void clrscr ()
{
    char clrscr[] = {0x1B, '[', '2', 'J', 0};
    pc.printf(clrscr);
}
//Home the cursor
void homescr()
{
    char homescr[] = {0x1B, '[', 'H', 0};
    pc.printf(homescr);
}
//goto specified line an column
void gotoscr(int line, int column)
{
    char scr[] = {0x1B, '[', 0x00,';',0x00, 'H', 0};
    scr[2] = line;
    scr[4] = column;
    pc.printf(scr);
}

// When characteristic LED RGB changing

void LEDupdate(uint32_t newColor)
{
    // read individual bytes
    uint8_t* channels = (uint8_t*)&newColor;

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    Red   = static_cast<float>(channels[0]) / 255.0f;
    Green = static_cast<float>(channels[1]) / 255.0f;
    Blue  = static_cast<float>(channels[2]) / 255.0f;
    gotoscr('5','0');
    pc.printf("PWM Red = ");
    pc.printf("%5.2f",Red);
    gotoscr('6','0');
    pc.printf("PWM Green = ");
    pc.printf("%5.2f",Green);
    gotoscr('7','0');
    pc.printf("PWM Blue = ");
    pc.printf("%5.2f",Blue);
}

// When characteristic PWM output changing

void PWMupdate(uint8_t pwmvalue)
{

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    PWMoutput   = static_cast<float>(pwmvalue) / 255.0f;
    
    gotoscr('4','0');
    pc.printf("PWM = ");
    pc.printf("%5.2f",PWMoutput);
}

// When characteristic input changing
void Accupdate()
{

    //accX = float(short((acc.read_reg(LIS3DH_OUT_X_H) << 8) | acc.read_reg(LIS3DH_OUT_X_L))) * 0.001F / 15;
   //accY = float(short((acc.read_reg(LIS3DH_OUT_Y_H) << 8) | acc.read_reg(LIS3DH_OUT_Y_L))) * 0.001F / 15;
    //accZ = float(short((acc.read_reg(LIS3DH_OUT_Z_H) << 8) | acc.read_reg(LIS3DH_OUT_Z_L))) * 0.001F / 15;
    accX = 0.048f;
    
    gotoscr('0','0');
    pc.printf("X acceleration = ");
    pc.printf("%5.2f",accX);
    gotoscr('2','0');
    pc.printf("Y acceleration = ");
    //pc.printf("%5.2f",accY);
    gotoscr('3','0');
    pc.printf("Z acceleration = ");
    //pc.printf("%5.2f",accZ);
}

// Characteritic PWM LED RGB
SimpleChar<uint32_t> color = ble.writeOnly_u32(0x6200, 0x6201, &LEDupdate);

// Characteristic PWM output
SimpleChar<uint8_t> pwmout = ble.writeOnly_u8(0xA000, 0xA001, &PWMupdate);


void skater_d()
{
    if(flag==false) {
        //printf("Ligne de depart coupee solo \n");
        if( flag == false) {
            //printf("Depart skate \n");
            begin = timer.read_ms();
            compteur=100;
            //pc.printf("                                         skater lance %.0f \n", begin);
            flag = true;
        } else if(flag == true) {
            //printf("erreur \n");
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    }
    else if(flag==true) {
        //printf("Ligne d'arrivee coupee \n");
        if( flag == false ) {
            //printf("arrivee coupe sans depart\n");
            flag = true;
        } else if(flag == true ) {
            //printf("Arrivee skate \n");
            end = timer.read_ms();
            temps = end-begin;
            compteur=200;
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    } 
}


//Main program

int main(int, char**)
{

    ble.start();
    clrscr();
    homescr();
    timer.start();
    //pc.printf("BLE started");
    Ticker t;
    t.attach(&Accupdate, 5.0f);
    event.fall(&skater_d);
    button1.fall(&Pressed);
    user1.fall(&Pressed);

    while (1) {
        ble.waitForEvent();

    }
}
