#include "mbed.h"
#include "config.h"
#include "IOFuncLib.h"
#include "BufferedSerial.h"
#include "Terminal.h"

//init standard
InterruptIn mybutton(USER_BUTTON);

Terminal term(USBTX, USBRX); // tx, rx
BufferedSerial pc(SERIAL_TX, SERIAL_RX); //Apertura della seriale 2
// originale!!!!!!!!!  BufferedSerial ardser(PA_11, PA_12); //Apertura della seriale 1 *opzionale vedi sotto
BufferedSerial ardser(PC_4, PC_5);
//init funzioni personal lib
Flasher led(LED1);
Screen sc(&pc);
//genFunctions fnz;
genFunctions fnzAdd; //messa qui rende la raccolta funzioni indipendente
Ticker ScreenSaver;

//var
int cont=0;
int dispType=0; //0:oled  1:lcd
bool status=false; //accensione
bool randomActivate=false; //se true attiva sul sequencer il cambio di valori casuali

string menu_main[10];
string menu_funcChoice[10];
/* 
0-Descrizione 
1-index function_val
*/
string menu_function[50];
int function_val[50][7]; //valori delle funzioni
/*
0-menu
1-funzione
2-min
3-max
4-step
5-valstart
6-valore attuale
*/

int menuidx=0;
int funcidx=0;
int funccontidx=0; //contatore di posizione durante caricamento

//---------- extern
// dichiarando qui le variabili extern, posso inizializzarle in qualunque parte del programma. In teoria parrebbe inutile ma in questo modo posso un domani istanziarle ovunque
extern int p01,p02,p03;
extern int p16, p17;
extern int p51, p52;

//------------ Funzioni -------------
#include "macroDisp.h"
#include "Functions.h"


int main()
{
    // Seriale Principale
    char c[4]; // variabile che contiene il carattere appena ricevuto
    char buffer[4][128]; // buffer di accumulo dei caratteri in sequenza
    char bufferTemp[128]; //buffer di appoggio per le funzioni di stampa. Sarebbe meglio evitarlo passando alla funzione una matrice
    char i[4]= {0,0,0,0}; // variabile di comodo per il conteggio dei caratteri

    //Serial config
    pc.baud(SERIAL1BAUD);
    ardser.baud(SERIALARDBAUD);
    //pc.format(int bits=8, Parity parity=SerialBase::None, int stop_bits=1)

    mybutton.fall(&pressed);
    ScreenSaver.attach(&scsa,60);

    //ardser
    ardser.printf("Connected\r");
    // display
    initDisp(dispType);
    setFontDisp(dispType,'N');
    bannerDisp(dispType);
    //terminal
    bannerAdv();
    preloadValue();
    //richiedi menu
   ardser.printf("rl\r");

    while(1) {
        // ardser.attach(&callback);
        //seriale interna
        if (pc.readable()) {
            c[0]=pc.getc(); //legge un carattere dalla seriale
            term.putc(c[0]); //redirect to terminal
            if (c[0] != 13)  {
                buffer[0][i[0]]=c[0]; // se il carattere è diverso da CarriageReturn (ASCII 13) lo memorizza nel buffer
                i[0]++; // incrementa il puntatore al buffer
                led.flash(2);
            } else {
                //pc.printf("\n\r");
                buffer[0][i[0]]=0; //se è un CR inserisci un carattere nullo nel buffer per delimitare la stringa
                //controlla di non  mandare solo un CR
                if (i[0]>0) {
                    for(int ii=0; ii<=i[0]; ii++) bufferTemp[ii]=buffer[0][ii];
                    parserVT100(bufferTemp);
                } else term.readypos();
                i[0]=0; //azzera la posizione del puntatore del buffer pronto per la ricezione di una nuova stringa
            }
        }

        //seriale esterna
        if (ardser.readable()) {
            c[1]=ardser.getc(); //legge un carattere dalla seriale
            if ((c[1] != 10) && (c[1] != 13))   {
                buffer[1][i[1]]=c[1]; // se il carattere è diverso da CarriageReturn (ASCII 13) lo memorizza nel buffer
                i[1]++; // incrementa il puntatore al buffer
            } else {
                //ardser.printf("\n\r");
                buffer[1][i[1]]=0; //se è un CR inserisci un carattere nullo nel buffer per delimitare la stringa
                //controlla di non  mandare solo un CR
                if (i[1]>0) {
                    for(int ii=0; ii<=i[1]; ii++) bufferTemp[ii]=buffer[1][ii];
                    writeInput(bufferTemp);
                } else term.readypos();
                i[1]=0; //azzera la posizione del puntatore del buffer pronto per la ricezione di una nuova stringa
            }
        }

    }
}



