//Oled
#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"

/* definitions for ST Nucleo L152RE  */
#define CSEL  PB_6  // CS  D10 PB_6
#define RST   PC_7  //     D9 rst pin9 PC_7
#define DCMD  PA_9  // DC  D8 dc pin8 PA_9
#define CLK   PB_3  // CLK D13 d0 pin13 PA_5 //cambio necesario per far funzionare led
#define DATA  PB_5  // MOSI D11 d1 pin11 PA_7 //cambio necesario per far funzionare led


SSD1306 oled(CSEL, RST, DCMD, CLK, DATA);   // STM32 Nucleo


static const unsigned char  oldlogo16_glcd_bmp[] = {
    0x00, 0xc0, // B00000000, B11000000,
    0x01, 0xc0, // B00000001, B11000000,
    0x01, 0xc0, // B00000001, B11000000,
    0x03, 0xe0, // B00000011, B11100000,
    0xf3, 0xe0, // B11110011, B11100000,
    0xfe, 0xf8, // B11111110, B11111000,
    0x7e, 0xff, // B01111110, B11111111,
    0x33, 0x9f, // B00110011, B10011111,
    0x1f, 0xfc, // B00011111, B11111100,
    0x0d, 0x70, // B00001101, B01110000,
    0x1b, 0xa0, // B00011011, B10100000,
    0x3f, 0xe0, // B00111111, B11100000,
    0x3f, 0xf0, // B00111111, B11110000,
    0x7c, 0xf0, // B01111100, B11110000,
    0x70, 0x70, // B01110000, B01110000,
    0x00, 0x30
}; // B00000000, B00110000 };

static const unsigned char  dog16_glcd_bmp[] = {
    0x18, 0x18, // B00000000, B11000000,
    0x26, 0x64, // B00000001, B11000000,
    0x42, 0x42, // B00000001, B11000000,
    0x41, 0x82, // B00000011, B11100000,
    0x40, 0x2, // B11110011, B11100000,
    0x80, 0x1 , // B11111110, B11111000,
    0x8C, 0x31, // B01111110, B11111111,
    0x8C, 0x31, // B00110011, B10011111,
    0x40, 0x2 , // B00011111, B11111100,
    0x41, 0x82, // B00001101, B01110000,
    0x21, 0x84, // B00011011, B10100000,
    0x10, 0x8 , // B00111111, B11100000,
    0x13, 0xC8, // B00111111, B11110000,
    0x8 , 0x10, // B01111100, B11110000,
    0x4, 0x20, // B01110000, B01110000,
    0x3 , 0xC0
};

static const unsigned char logo16_glcd_bmp[] = {
    0x1 , 0x80, // B00000000, B11000000,
    0x1 , 0xC0, // B00000001, B11000000,
    0x1 , 0xE0, // B00000001, B11000000,
    0x1 , 0xB0, // B00000011, B11100000,
    0x1 , 0x98, // B11110011, B11100000,
    0x1 , 0x8C, // B11111110, B11111000,
    0x1 , 0x86, // B01111110, B11111111,
    0xFF, 0x83, // B00110011, B10011111,
    0xFF, 0x8F, // B00011111, B11111100,
    0x60, 0x10, // B00001101, B01110000,
    0x30, 0x20, // B00011011, B10100000,
    0x18, 0x4F, // B00111111, B11100000,
    0xC , 0xF2, // B00111111, B11110000,
    0x6 , 0x4 , // B01111100, B11110000,
    0x3,  0x8 , // B01110000, B01110000,
    0x1 , 0xF0
};
//---------- oled -----------------------

bool initDisp(int disptype)
{
    bool ret=true;
    switch (disptype) {
        case 0: //oled
            oled.initialise();
            oled.clear();
            oled.set_contrast(255); // max contrast
            oled.update();
            break;
        case 1: //lcd
            break;
    }
    return ret;
}

void bannerDisp(int disptype)
{
    switch (disptype) {
        case 0: //oled
            oled.clear();
            oled.printf("-_-_ Boot screen _-_-\n\r");
            oled.printf("Nucleo Scorda IO Test\n\r");
            oled.update();
            break;
        case 1: //lcd
            break;
    }
}

void setFontDisp(int disptype, char fontType)
{
    switch (disptype) {
        case 0: //oled
            if (fontType=='N')  oled.set_font(standard_font, 6);
            if (fontType=='B')  oled.set_font(bold_font, 8);
            if (fontType=='D')  oled.set_double_height_text(1);
            break;
        case 1: //lcd
            break;
    }
}

void printDisp(int disptype, char *format)
{
    switch (disptype) {
        case 0: //oled
            oled.printf(format);
            oled.update();
            break;
        case 1: //lcd
            break;
    }
}

void inverseDisp(int disptype)
{
    static bool boolf=0;
    switch (disptype) {
        case 0: //oled
            boolf=!boolf;
            oled.set_inverse(boolf);
            //oled.update();
            break;
        case 1: //lcd
            break;
    }
}