#include <string>
#include "IOFuncLib.h"
#include "choiceFunctions.h"

//Valori di Menu
int p16, p17;
int p01, p02, p03;
int p51, p52;

void bannerAdv()
{
    //spostato qui per lasciare in pace la libreria
    term.reset();
    term.cls();
    term.frame(0, 0, 79, 22,1);
    term.forgcol(3);
    term.bold();
    term.formatPrintf("_____ H-Ard Synth Project Console _____\n",19,1);
    term.formatPrintf("______ Nucleo Scorda IO Terminal ______\n",19,2);

    term.resetattrib();
    term.forgcol(7);
//3-4
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,3,1); //top 1/2
    term.forgcol(6);
    /*
    //5-6
    term.formatPrintf("Pattern 0......... \n",2,6); //p11
    term.formatPrintf("Pattern 1......... \n",42,6); //p12
    //7-8

    //9-10
    term.formatPrintf("Serial Real(sro/f) \n",2,10); //p31
    //11-12
    term.formatPrintf("Note Pattern......\n",2,12,99); //p41
    */
    //16
    p16=16;
    p17=16;
    term.formatPrintf("Status   \n",2,p16); //p16
    term.formatPrintf("Random \n",32,p17); //p17
//18-19
    p51=18;
    p52=18;
    term.formatPrintf("Input string...... \n",2,p51); //p51
    term.formatPrintf("Command Type \n",48,p52); //p52
    p01=19;
    p02=19;
    p03=19;
    term.formatPrintf("Funzione \n",2,p01); //p01
    term.formatPrintf("Numero \n",32,p02); //p02
    term.formatPrintf("Parametro \n",51,p03);  //p03
//21
    term.forgcol(7);
    term.formatPrintf("Serial Feedback \n",2,21);


// grigino
    /*
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,5); //top 3/4
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,9); //top 7/8
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,13); //top 11/12

    term.forgcol(2);
    term.formatPrintf("Pattern: da 031 a 252 - Traccia 0-2, Note 3-6, Len 1-2 \n",2,16); //help
    term.formatPrintf("Stato random: r1on-r1off \n",2,17); //help
    term.formatPrintf("Cambia Note: da n01 a n53 - Nota 0-5, Val 1-3 \n",2,18); //help
    term.formatPrintf("start, stop, dstop (delay) - rl: reload value\n",2,19); //help
    term.forgcol(7);
    */
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,15,1); //bottom pot
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,17,1); //bottom pot
    term.formatPrintf(fnzAdd.string2char(fnzAdd.padstr("\n",78,char(196))),1,20); //azzo funziona...
    term.locate(0, 23);
    printf("Command: > ");

}


void callback()
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    // ardser.printf("%d \n", cont++);
//  myled2 = !myled2;
}

void scsa()
{
    //Funzione per screensaver
    inverseDisp(dispType);
}


void parserVT100(char stringa[])
{
    string func; //funzione l=led
    string funcnum; //funzione ordinata 1,2,3 ecc
    string param; //parametro on, off
    string strIn = string(stringa);
    bool errp=1;
    //pad a 4
    strIn=fnzAdd.padstr(strIn,5,' ');
    strIn=fnzAdd.addEOS(strIn);
    //split
    func=strIn.substr(0,1);
    funcnum=strIn.substr(1,1);
    param=strIn.substr(2,3);
    //write param
    term.formatPrintf(fnzAdd.string2char(fnzAdd.addEOS(func)),11,p01,10,1);       //p01
    term.formatPrintf(fnzAdd.string2char(fnzAdd.addEOS(funcnum)),39,p02,10,1);    //p02
    term.formatPrintf(fnzAdd.string2char(fnzAdd.addEOS(param)),61,p03,10,1);      //p03
    //write input string
    term.formatPrintf(fnzAdd.string2char(strIn),21,p51,10,1); //p51
    //term.formatPrintf(((char*)func.c_str() ,02,07); funziona anche cosi'

    //in arrivo e carica funzioni da Arduino
    if (func=="f") {
        errp=funcOut(func, string(stringa));
    }

    //led for test
    else if (func=="l") {
        errp=Lfunc(func, funcnum,param);
    }

    //in arrivo e carica menu da Arduino
    else if (func=="m") {
        errp=menuOut(func,string(stringa));
    }

    //Random Activate 
    else if (func=="r") {
        errp=RfuncOut(func, strIn);
    }

    //Random Activate 
    else if (strIn.substr(0,2)=="so"){
        errp=sensorOut(func, strIn);
    }

    //start
    else if (strIn.substr(0,5)=="start") {
        errp=StartfuncOut();
    }

    //stop
    else if (strIn.substr(0,4)=="stop") {
        errp=StopfuncOut();
    }

    else if (func=="+") {
        errp=plusOut(func,string(stringa));
    }

    else if (func=="-") {
        errp=minusOut(func,string(stringa));
    }

    // comando fuori parsing
    if (errp==1) {
        term.forgcol(1);
        term.formatPrintf("Bad Command\n",61,p52,99,1); //p52
        term.forgcol(9);
        ardser.printf("Bad command\n\r");
        printDisp(dispType,"** Bad command ** \n\r");
    }
    if (errp==0) term.readypos(); //riposiziono solo solo se a 0
}


void writeInput(char stringa[])
{
    string func; //funzione l=led
    string funcnum; //funzione ordinata 1,2,3 ecc
    string param; //parametro on, off
    string strIn = string(stringa);
    bool errp=1;
    strIn=fnzAdd.padstr(strIn,5,' '); //non dovrebbe servire
    strIn=fnzAdd.addEOS(strIn);
    //split
    func=strIn.substr(0,1);
    funcnum=strIn.substr(1,1);
    param=strIn.substr(2,3);


    //Descrizione Menu in input
    if (func=="m") {
        errp=menuIn(func, stringa);
    }
    //Descrizione funzione in input
    else if (func=="f") {
        errp=functionIn(func, stringa);
    }
    //Parametri in ingresso
    else if (func=="g") {
        errp=getParamIn(func, stringa);
    }
    //start
    else if (strIn.substr(0,4)=="start") {
        errp=StartfuncIn();
    }
    //stop
    else if (strIn.substr(0,3)=="stop") {
        errp=StopfuncIn();
    }
    //Valori funzione in input
    else if (func=="v") {
        errp=valueIn(stringa);
    }

//writeLogInput( strIn{
    term.formatPrintf(fnzAdd.string2char(">"+fnzAdd.subEOS(string(stringa))+"<"),18,21,99,1);
    if (errp==0) term.readypos();
}

void preloadValue()
{
    string func; //funzione l=led
    string funcnum; //funzione ordinata 1,2,3 ecc
    string param; //parametro on, off
    string strIn;

    //azzero vettori
    for (int i = 0; i < 10; i++) {
        menu_main[i]="";
        menu_funcChoice[i]="";
    }
    for (int i = 0; i < 50; i++) {
        menu_function[i]="";
    }
    menu_main[0]="Z.Z"; //invero e' sbagliato. controllare cosa usa di stop
    menu_funcChoice[0]="Z.Z";
    menu_function[0]="Z.Z";

    status=false; //accensione
    randomActivate=false;
    term.formatPrintf(fnzAdd.string2char(fnzAdd.addEOS("Off")),11,p16,10,1);
    term.formatPrintf(fnzAdd.string2char(fnzAdd.addEOS("Off")),39,p17,10,1);

    term.readypos();
}



void pressed()
{
    term.erasesquare(1, 4, 78, 14);
    ardser.printf("rl\r");
    term.formatPrintf("rl\n",21,p51,8,1); //p51
    term.formatPrintf("Ask for reload\n",61,p52,99,1);   //p52
    led.flash(2);
}




