#include "EFM32_SegmentLCD.h"
#include "EFM32_CapSenseSlider.h"

/******************** Define I/O *****************************/
InterruptIn in0(PB9);
InterruptIn in1(PB10);

silabs::EFM32_SegmentLCD segmentDisplay;
silabs::EFM32_CapSenseSlider capSlider;

/******************** Define Timers *****************************/
LowPowerTicker refreshTicker;

/***************** Define global variables **********************/
#define INIT_SECONDS		17600
#define TEST_DURATION		10

volatile uint32_t seconds = INIT_SECONDS;
int count = -1;


/***************** Define callback handlers *********************/
void tickerCallback(void);
void in0_handler();
void in1_handler();
void touchCallback(void);
void slideCallback(void);

/**
 * Callback for pushbutton interrupt
 */

void symbolGest()
{
    if (count==7) {
        segmentDisplay.Symbol(LCD_SYMBOL_GECKO, true);
        segmentDisplay.Write("GeckoOn");
    } else {
        segmentDisplay.Symbol(LCD_SYMBOL_GECKO, false);
        if (count%2==0) segmentDisplay.Write("Scorda");
        else  segmentDisplay.Write("TataGek");
    }

}

void in0_handler()
{
    count++;
    if (count>7) count=7;
    else segmentDisplay.ARing(count, true);
    symbolGest() ;

}

void in1_handler()
{
    segmentDisplay.ARing(count, false);
    count--;
    if (count<0) count=-1;
    symbolGest() ;

}


/**
 * Callback for 1 second timebase
 */
void tickerCallback(void)
{
    seconds++;
    uint32_t clockValue = ((seconds / 60) % 60) * 100 + (seconds % 60);
    segmentDisplay.Number(clockValue);
    segmentDisplay.Symbol(LCD_SYMBOL_COL10, seconds & 0x1);
}

/**
 * Callback for touching/untouching the cap slider
 */
void touchCallback(void)
{
    segmentDisplay.Symbol(LCD_SYMBOL_EFM32, capSlider.isTouched());

    if(!capSlider.isTouched()) {
        segmentDisplay.Write("Scorda");
    }
}

/**
 * Callback for sliding the cap slider
 */
void slideCallback(void)
{
    segmentDisplay.LowerNumber(capSlider.get_position());
}

/*************************** MAIN *******************************/
int main()
{
    // Initialize pushbutton handler
    in0.rise(NULL);
    in0.fall(in0_handler);

    in1.rise(NULL);
    in1.fall(in1_handler);

    // Enable the capacitive slider
    capSlider.start();
    capSlider.attach_touch(touchCallback);
    capSlider.attach_untouch(touchCallback);
    capSlider.attach_slide(-1, slideCallback);

    // Start generating the 1Hz timebase
    refreshTicker.attach(&tickerCallback, 1.0f);

    printf("Initialization done! \n");
    wait(0.01f); //Need to delay slightly to give the serial transmission a chance to flush out its buffer
    segmentDisplay.Write("Scorda");


    // Go into sleeping mode
    while(1) {
        sleep();

        if(count >= 8) {
            /*
            	    // Go to 'completely dead' mode to show power consumption
            	    refreshTicker.detach();
            	    capSlider.stop();
            	    in.disable_irq();
            	    delete &segmentDisplay;

            	    */
        }

    }
}

