#include "config.h"
#include "IOFuncLib.h"
#include "BufferedSerial.h"

#include "mbed.h"

// FLASHER
Flasher::Flasher(PinName pin) : _pin(pin)
{
    _pin = 0;
}

void Flasher::flash(int n)
{
    for(int i=0; i<n*2; i++) {
        _pin = !_pin;
        wait(0.05f);
        // wait_ms(50);
    }
}

void Flasher::onOff(bool n)
{
    _pin=n;
}

void Flasher::notPin(void)
{
    _pin = !_pin;
}



// Screen
Screen::Screen(BufferedSerial* ps)
{
    _ps=ps;
}

void Screen::banner()
{
    genFunctions fA;
    writeScreen("_____ Boot screen _____\n",25,1);
    writeScreen("___ Nucleo Scorda IO Test ___\n",22,2);
    writeScreen(fA.string2char(fA.padstr("-\n",78,'-')),1,5); //azzo funziona...
    writeScreen("Parsing \n",2,5);
    writeScreen("Funzione\n",2,7);
    writeScreen("Numero\n",22,7);
    writeScreen("Parametro\n",42,7);
    writeScreen(fA.string2char(fA.padstr("-\n",78,'-')),1,10); //azzo funziona...
    writeScreen("Status \n",2,10);
    writeScreen("Led 1 \n",2,12);
    writeScreen("Virtual Led \n",22,12);
    writeScreen("Other Commands \n",42,12);
    writeScreen("Real Out Serial\n",62,12);
    writeScreen("Input string\n",2,15);
    writeScreen("Result\n",42,15);
    writeScreen(fA.string2char(fA.padstr("-\n",78,'-')),1,18); //azzo funziona...
    writeScreen("Serial Input \n",2,18);
    commitScreen();
}

void Screen::pressed()
{
    //_ps->printf("\f");
    // _ps->printf("*** Reset Screen ***\n\r\n");
    writeScreen("*** Reset Screen ***\n",1,1);
    commitScreen();
}

void Screen::commitScreen()
{
    _ps->printf("\f");
    for (int j = 0; j < screenRow-2; j++) {
        for (int i = 0; i < screenColumn; i++) {
            _ps->printf("%c",svec[i][j]);
        }
        _ps->printf("\n\r");
    }
}

void Screen::writeScreen(char sstr[], char xx, char yy, int padb)
{
    char i=0;
    while ((sstr[i]!='\n') && (i<(screenColumn-xx+1))) {
        // _ps->printf((char*) sstr[i]);
        svec[xx+i][yy]=sstr[i];
        i++;
    }
    //prosegui col pad
    while ((padb>0) && (i<(screenColumn-xx-1))) {
        svec[xx+i][yy]=' ';
        i++;
        padb--;
    }

}

void Screen::emptyFrame()
{
    char car;
    for (int j = 0; j < screenRow-2; j++) {
        if ((j==0) || (j==screenRow-3)) car='-';
        else car=' ';
        for (int i = 1; i < screenColumn-1; i++) {
            svec[i][j]=car;
        }
        svec[0][j]='|';
        svec[screenColumn-1][j]='|';
    }
}

void Screen::clearScreen(char upperx, char uppery, char loverx, char lowery)
{
    //controllare margini
    for (int j = uppery; j <= lowery; j++) {
        for (int i = upperx; i <= loverx; i++) {
            svec[i][j]=' ' ;
        }
    }
}


// general

char* genFunctions::subchar(char* arr, int begin, int len)
{
    //non funziona
    char* res = new char[len];
    for (int i = 0; i < len; i++)
        res[i] = *(arr + begin + i);
    res[len] = 0;
    return res;
}

string genFunctions::padstr(string sttde, int maxlen, char fillchar)
{
    bool flagEOS=false;
    string ret=sttde;
    if (ret.size()>0) {
        //se ha EOS lo tolgo
        if (ret.substr(ret.size()-1,1) == EOS) {
            ret=ret.substr(0,ret.size()-1);
            flagEOS=true;
        }
        //pad
        if (maxlen> ret.size()) ret.insert(ret.size(), maxlen - ret.size(), fillchar);
        //se aveva EOS, lo rimetto
        if (flagEOS==true) ret=addEOS(ret);
    }
    return ret;
}

string genFunctions::addEOS(string sttde)
{
    string ret=sttde;
    if (sttde.substr(sttde.size()-1,1) != "\n") ret=sttde+"\n";
    return ret;
}

string genFunctions::subEOS(string sttde)
{
    string ret=sttde;
    if (sttde.substr(sttde.size()-1,1) == "\n") ret=sttde.substr(0,sttde.size()-2);
    return ret;
}

char* genFunctions::string2char(string sttde)
{
    //ora aggiunge comunque l'EOS. Decidere se parametrizzare
    sttde=addEOS(sttde);
    char *cstr = new char[sttde.length() + 1];
    strcpy(cstr, sttde.c_str());
    // delete [] cstr;
    return cstr;
}

int genFunctions::c2i(char sttde)
{
    // single char to integer
    return sttde-'0';;
}

string genFunctions::i2s(int number)
{
    // integer to string
    if (number == 0)
        return "0";
    string temp="";
    string returnvalue="";
    while (number>0) {
        temp+=number%10+48;
        number/=10;
    }
    for (int i=0; i<temp.length(); i++)
        returnvalue+=temp[temp.length()-i-1];
    return returnvalue;
}




/* atof: convert string s to double */
double genFunctions::atof(char s[])
{
    double val, power;
    int i, sign;


    for (i = 0; isspace(s[i]); i++); /* skip white space */

    sign = (s[i] == '-') ? -1 : 1;
    if (s[i] == '+' || s[i] == '-') i++;
    for (val = 0.0; isdigit(s[i]);  i++) {
        val = 10.0 * val + (s[i] - '0');
    }
    if (s[i] == '.') i++;
    for (power = 1.0; isdigit(s[i]); i++) {
        val = 10.0 * val + (s[i] - '0');
        power *= 10.0;
    }
    return sign * val / power;
}

/* itoa: convert n to characters in s */
void genFunctions::itoa(int n, char s[])
{
    int i, sign;
    if ((sign = n) < 0) /* record sign */
        n = -n; /* make n positive */
    i = 0;
    do { /* generate digits in reverse order */
        s[i++] = n % 10 + '0'; /* get next digit */
    } while ((n /= 10) > 0); /* delete it */
    if (sign < 0) s[i++] = '-';
    s[i] = '\0';
    reverse(s) ;
}


/* reverse: reverse string s in place */
void genFunctions::reverse(char s[])
{
    int c, i, j;
    for (i = 0, j = strlen(s)-1; i < j; i++, j-- ) {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}


/* atoi: convert s to integer; version 2 */
int genFunctions::atoi(char s[])
{
    int i, n, sign;
    for (i = 0; isspace(s[i]) ; i++) {
        ;   /* skip white space */
    }
    sign= (s[i] == '-') ? -1 : 1;
    if (s[i] == '+' || s[i] == '-') i++; /* skip sign */
    for (n = 0; isdigit(s[i]); i++ ) {
        ;
    }
    n = 10 * n + (s[i] - '0');
    return sign * n;
}

int genFunctions::constrain(int amt, int low, int high)
{
    int ret=amt;
    if (amt>high) ret=high;
    else if (amt<low) ret= low;
    return ret;
    //return ((amt)<(low)?(low):((amt)>(high)?(high):(amt)));
}

int genFunctions::min(int a, int b)
{
    return  ((a)<(b)?(a):(b));
}

int genFunctions::max(int a, int b)
{
    return ((a)>(b)?(a):(b));
}

int genFunctions::abs(int x)
{
    return ((x)>0?(x):-(x));
}

/* trim: remove trailing blanks, tabs, newlines */
int genFunctions::trim(char s[])
{
    int n;
    for (n = strlen(s)-1; n >= 0; n--) {
        if (s[n] != ' ' && s[n] != '\t' && s[n] != '\n')  break;
    }
    s[n+1] = '\0';
    return n;
}