#ifndef IOFUNCLIB_H
#define IOFUNCLIB_H
#include <string>
#include "BufferedSerial.h"
#include <ctype.h>

#include "mbed.h"

class Flasher
{
public:
    Flasher(PinName pin);
    void flash(int n);
    void onOff(bool n);
    void notPin(void);

private:
    DigitalOut _pin;
};


class Screen
{
public:
    Screen(BufferedSerial* ps);

    void banner();
    void pressed();
    //vettore schermo
    void commitScreen();
    void emptyFrame();
    void clearScreen(char upperx, char uppery, char loverx, char lowery);
    void writeScreen(char sstr[], char xx, char yy, int padb=0);

private:
    /**
     * Receive bytes from the serial port and store it into the receive queue.
     */
    BufferedSerial* _ps;
    // vettore schermo
    char svec[80][24] ;
};



class genFunctions
{
public:
    //genFunctions();
    char* subchar(char* arr, int begin, int len);
    string padstr(string sttde, int maxlen, char fillchar);
    string addEOS(string sttde) ;
    string subEOS(string sttde) ;
    char* string2char(string sttde);
    int constrain(int amt, int low, int high);
    int c2i(char sttde);
    double atof(char s[]);
    string i2s(int nnum);
    void reverse(char s[]);
    int atoi(char s[]);
    void itoa(int n, char s[]);
    int min(int a, int b);
    int max(int a, int b);
    int abs(int x);
    int trim(char s[]);

private:
};

#endif
