#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

Serial NFC(PF_7,PF_6,115200);
Serial pc(USBTX, USBRX,115200);
char message[25];
char msg[25];
DigitalOut led1(LED1);
int q=0;
const unsigned char wake[24]={
  0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 0xfd, 0xd4, 0x14, 0x01, 0x17, 0x00};//wake up NFC module
const unsigned char firmware[9]={
  0x00, 0x00, 0xFF, 0x02, 0xFE, 0xD4, 0x02, 0x2A, 0x00};//
const unsigned char tag[11]={
  0x00, 0x00, 0xFF, 0x04, 0xFC, 0xD4, 0x4A, 0x01, 0x00, 0xE1, 0x00};//detecting tag command
const unsigned char std_ACK[25] = {
  0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x0C, \
0xF4, 0xD5, 0x4B, 0x01, 0x01, 0x00, 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x00};
unsigned char old_id[5];

unsigned char receive_ACK[25];//Command receiving buffer

void NFC_Send_Byte(unsigned char command_data){//send byte to PC
  NFC.putc(command_data);
}
void send_tag(void){//send tag[] to device
  unsigned char i;
  for(i=0;i<11;i++) //send command
    NFC_Send_Byte(tag[i]);
}
void wake_card(void){//send wake[] to device
  unsigned char i;
  for(i=0;i<24;i++) //send command
    NFC_Send_Byte(wake[i]);
}



void read_ACK(unsigned char temp){//read ACK into reveive_ACK[]
  unsigned char i;
  for(i=0;i<temp;i++) {
    message[i]= NFC.getc();
  }
}
void pc_Send_Byte(unsigned char command_data){//send byte to PC
  pc.putc(command_data);
}

void display(unsigned char tem){//send receive_ACK[] to PC
  unsigned char i;
  for(i=0;i<tem;i++) //send command
    pc_Send_Byte(receive_ACK[i]);
  pc.printf("\r\n");
}

void firmware_version(void){//send fireware[] to device
  unsigned char i;
  for(i=0;i<9;i++) //send command
    NFC_Send_Byte(firmware[i]);
}


int main()
{  
    
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    
        status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    
    wait(1);
    wake_card();
    pc.printf("\r\n");
    send_tag();
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
      lcd.SetTextColor(LCD_COLOR_RED);
      lcd.FillRect(100, 100, 100, 75);
      lcd.DisplayStringAt(0, LINE(3), (uint8_t *) "       SCAN", LEFT_MODE);
    while(1)
    {
      
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) 
        {
            x = TS_State.touchX[0];
            y = TS_State.touchY[0];
            if((x >115) && (x <190) && (y>125) && (y<170))
            {
                lcd.SetTextColor(LCD_COLOR_GREEN);
                 lcd.FillRect(100, 100, 100, 75);
                 send_tag();
                 wait(0.200);
                 read_ACK(18);
            }
            else
            {
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.FillRect(100, 100, 100, 75);
                }
        }
        else{
            lcd.SetTextColor(LCD_COLOR_RED);
                lcd.FillRect(100, 100, 100, 75);
            }

        
      
      q=0;
          sprintf(msg, "ID %d %02X%02X%02X%02X%02X%02X",q,(int)message[13],(int)message[14],(int)message[15],(int)message[16],(int)message[17],(int)message[18]);
      lcd.DisplayStringAt(0,LINE(9), (uint8_t *)msg, CENTER_MODE);
      
    }
}

