#include "mbed.h"

I2C i2c(p28, p27);
BusOut myled(LED1,LED2,LED3,LED4);
BusOut myrgb(P1_23,P1_25,P1_24);
DigitalOut LedBlue(P1_28);
BusIn myline(p18,p16,p19,p17);
DigitalIn linecenter(p20);
DigitalOut online(P1_6);
PwmOut MotorL_EN(P1_15);         
DigitalOut MotorL_FORWARD(P1_1);   
DigitalOut MotorL_REVERSE(P1_0);
PwmOut MotorR_EN(P0_21);
DigitalOut MotorR_FORWARD(P1_3);
DigitalOut MotorR_REVERSE(P1_4);
DigitalOut Motor_SENSOR(P1_7);
DigitalOut enable(P1_2);
DigitalIn SensorL(P1_12);  
DigitalIn SensorR(P1_13);
float slow = 0.25;
float fast = 0.50;
int out_helper[8];
int main() 
{
    out_helper[0]=0;
    out_helper[1]=1;
    out_helper[2]=3;
    out_helper[3]=7;
    out_helper[4]=15;
    out_helper[5]=14;
    out_helper[6]=12;
    out_helper[7]=8;
    
    enable = 0;
    online = 0;
    Motor_SENSOR=0;
    
    myrgb = 0x07;//7->aus
    LedBlue=1;
    myled = 0x00;
    
    MotorL_EN = 0;         
    MotorL_FORWARD = 0;   
    MotorL_REVERSE = 0;
    MotorR_EN = 0;
    MotorR_FORWARD = 0;
    MotorR_REVERSE = 0;
    
    i2c.start();
       i2c.write(0x40);
       i2c.write(0x06);
       i2c.write(0x00);
    i2c.stop(); 
    
    i2c.start();
      i2c.write(0x40);
      i2c.write(0x02);
      i2c.write(~0x00);
    i2c.stop();
    
    int waiting = 0;
    int output = 0xff;
    bool active = false;
    
    while(1){
        if(active)
        {
            enable = 1;
            online = 1;
            if((myline==0&&linecenter==0)||(myline==15&&linecenter==1))
            {
                active = false;
                MotorL_EN = 0;         
                MotorL_FORWARD = 0;   
                MotorL_REVERSE = 0;
                MotorR_EN = 0;
                MotorR_FORWARD = 0;
                MotorR_REVERSE = 0;
            }
            else
            {
                output = 0xff;
                if((myline&0x08)>0)
                {
                    MotorR_FORWARD = 0;  
                    MotorR_EN=0;
                    output=output&(~0x80);
                }
                else
                {
                    MotorR_FORWARD = 1;  
                    if((myline&0x04)>0)
                    {
                        MotorR_EN=slow;
                        output=output&(~0x40);
                    }
                    else
                        MotorR_EN=fast;
                }
                
                if((myline&0x01)>0)
                {
                    MotorL_EN=0;
                    MotorL_FORWARD = 0;  
                    output=output&(~0x10);
                }
                else
                {
                    MotorL_FORWARD = 1;  
                    if((myline&0x02)>0)
                    {
                        MotorL_EN=slow;
                        output=output&(~0x20);
                    }
                    else
                        MotorL_EN=fast;
                }
                myled=myline;
                i2c.start();
                  i2c.write(0x40);
                  i2c.write(0x02); 
                  i2c.write(output);
                i2c.stop();
            }
            myrgb=3;
        }
        else
        {
            i2c.start();
              i2c.write(0x40);
              i2c.write(0x02);
              i2c.write(~0x90);
            i2c.stop();
            if(waiting<7)
            {
                wait(0.5);
                if(waiting==0)
                {
                    enable = 0;
                    online = 0;
                    myrgb=7;
                }
                waiting++;
            }
            else
            {
                enable = 1;
                online = 1;
                wait(0.5);
                if(myline==15&&linecenter==1)
                    myrgb=0;
                else
                if((myline>=1)||(linecenter==1))
                {
                    active=true;
                    myrgb=5;
                    myled=0;
                    wait(0.5);
                }
                else
                    myrgb=6;
                waiting=0;
            }
            if(!active)
                myled=out_helper[waiting];
        }
        //0=>keine Linie
        
        //01->forneMitte
        //02->hintenMitte
        //04->forneLinks
        //08->forneRects
        //10->hintenLinks
        //20->hintenRechts
        //40->Rechts
        //80->Links
        
        //01->LinksWeis
        //02->VorneGelbLinks
        //04->RechtsWeis
        //08->VorneGelbRechts
        //10->LinksRot
        //20->HintenGelbLinks
        //40->HintenGelbRechts
        //80->RechtsRot
        }
}