#include "mbed.h"
#include "SongPlayer.h"
#include "DRV2605.h"

Ticker speaker;
Ticker hapticMotor;
SongPlayer mySpeaker(p21);
DRV2605 haptics(p9, p10);
Serial Blue(p28,p27);
BusOut myled(LED1,LED2,LED3,LED4);

//Global Variables
float note[1] = {0.0};
float duration[1] = {0.0};
int randomVibe = 0;
volatile bool button_ready = 0;
volatile int  bnum = 0;
volatile int  bhit = 0;
enum statetype {start = 0, got_exclm, got_B, got_num, got_hit};
statetype state = start;

// Random
volatile int interruptControl = 1;

void parse_message()
{
    switch (state) {
        case start:
            if (Blue.getc()=='!') state = got_exclm;
            else state = start;
            break;
        case got_exclm:
            if (Blue.getc() == 'B') state = got_B;
            else state = start;
            break;
        case got_B:
            bnum = Blue.getc();
            state = got_num;
            break;
        case got_num:
            bhit = Blue.getc();
            state = got_hit;
            break;
        case got_hit:
            if (Blue.getc() == char(~('!' + ' B' + bnum + bhit))) button_ready = 1;
            state = start;
            break;
        default:
            Blue.getc();
            state = start;
    }
}

void speakerPB1 (void)
{
    while (bhit == '1') {
        myled = 0x01;
        note[0] = (static_cast <float> (rand()) / static_cast <float> (RAND_MAX))*6000.0 + 2000.0;
        duration[0] = (static_cast <float> (rand()) / static_cast <float> (RAND_MAX))*0.1;
        mySpeaker.PlaySong(note,duration);
    }
}

void motorPB2 (void)
{
    while (bhit == '1') {
        myled = 0x0;
        haptics.play_waveform(14);
    }
}

void motorISR (void)
{
    if (interruptControl == 1) {
        randomVibe = rand()%123 + 1; // Produces random number from 1 to 123
        haptics.play_waveform(randomVibe);  
    }
}

void speakerISR (void)
{
    if (interruptControl == 1) {
        note[0] = (static_cast <float> (rand()) / static_cast <float> (RAND_MAX))*6000.0 + 2000.0;
        duration[0] = (static_cast <float> (rand()) / static_cast <float> (RAND_MAX))*0.5;
        mySpeaker.PlaySong(note,duration);
    }
}


int main()
{
    Blue.attach(&parse_message,Serial::RxIrq);
    hapticMotor.attach(&motorISR, 0.5);
    speaker.attach(&speakerISR, 1.5);

    while(1) {
        if (button_ready == 1 && bnum == '1') {
            myled = 0x01; // 
            speakerPB1();
        } else if (button_ready == 1 && bnum == '2') {
            myled = 0x02;
            motorPB2();
        } else if (button_ready == 1 && bnum == '3') {
            myled = 0x04;
            interruptControl = 1;
        } else if (button_ready == 1 && bnum == '4') {
            myled = 0x08;
            interruptControl = 0;
        }
    }
}



