/**
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "lora_radio.h"
#include "lora_radio_helper.h"

//#include "serial.h"

using namespace events;

// Max payload size can be LORAMAC_PHY_MAXPAYLOAD.
// This example only communicates with much shorter messages (<30 bytes).
// If longer messages are used, these buffers must be changed accordingly.

static uint8_t lora_rx_buffer[30];


/**
 * Constructing Mbed LoRaWANInterface and passing it the radio object from lora_radio_helper.
 */
static LoRaWANInterface lorawan(radio);


void lorawan_add_callbacks(lorawan_app_callbacks_t LoraWanCallbacks){
    lorawan.add_app_callbacks(&LoraWanCallbacks);
}

int lorawan_connect(){
    lorawan_status_t retcode;
    retcode = lorawan.connect();
    
    if (retcode == LORAWAN_STATUS_OK ||
            retcode == LORAWAN_STATUS_CONNECT_IN_PROGRESS) {
                return 0;
    } else {
        return -1;
    }
}

int lorawan_enable_adaptive_datarate(){
    if (lorawan.enable_adaptive_datarate() != LORAWAN_STATUS_OK) {
        return -1;
    }else{
        return 0;
    }
}
 
int lorawan_set_confirmed_msg_retries(unsigned int number_of_retries){
    if (lorawan.set_confirmed_msg_retries(number_of_retries)
            != LORAWAN_STATUS_OK) {
        return -1;
    }else{
        return 0;
    }
}

int lorawan_initialize_stack(EventQueue *ev_queue){
    if(lorawan.initialize(ev_queue) != LORAWAN_STATUS_OK){
        return -1;
    }else
        return 0;
}
 
/**
 * Sends a message to the Network Server
 */
int lora_send_message(uint8_t *msg_to_transmit, uint16_t packet_len)
{
    int16_t retcode;
    
    retcode = lorawan.send(MBED_CONF_LORA_APP_PORT, msg_to_transmit, packet_len,MSG_UNCONFIRMED_FLAG);

    return (int)retcode;
}

/**
 * Receive a message from the Network Server
 */
int lora_receive_message()
{
    uint8_t port;
    int flags;
    int16_t retcode = lorawan.receive(lora_rx_buffer, sizeof(lora_rx_buffer), port, flags);

    if (retcode < 0) {
        return (int)retcode;
    }

    /*Justo for Debug
    for (uint8_t i = 0; i < retcode; i++) {
        pc.printf("%02x ", rx_buffer[i]);
    }
    pc.printf("\r\n");
    */
    /*
    it clean the buffer, so useless
    memset(rx_buffer, 0, sizeof(rx_buffer));
    */
    
    return (int)retcode;
}



// EOF
