#include "mbed.h"
#include "AccelStepper.h"
#include "PinNames.h"
#include "stdio.h"
//#include <avr/wdt.h>

Serial pc(USBTX, USBRX);


//Pins
#define STP1_PIN 2 //AnalogOut STP_PIN(nome do pino da placa) ##DESCOMENTAR ESSE BLOCO##
#define DIR1_PIN 3 // AnalogOut DIR_PIN(nome do pino da placa)
/*#define ENA_PIN 2 // DigitalOut ENA_PIN(nome do pino da placa)
#define HOM_PIN 12*/ // DigitalIn HOM_PIN(nome do pino da placa)

//AnalogOut STP_PIN(PTB0);
//AnalogOut DIR_PIN(PTB1);
DigitalOut ENA_PIN(P1_13);
DigitalIn HOM_PIN(P0_28);

//Max
#define MAX_ACCEL_mms2 500.0
#define MAX_SPEED_mms  75.0
#define MAX_POS_mm 100.0

//Stepper Motor parameters
#define STEPS_by_REV  400.0
#define mm_by_REV 25.0

//Home Parameters
#define HOME_SPEED_mms  10.0
#define HOME_INCREMENT_mm  1.0
#define HOME_PRESS_POSITION_mm  2.0

//Consts
const unsigned int MAX_ACCEL_STEPS2 = (MAX_ACCEL_mms2 *  STEPS_by_REV) / mm_by_REV;
unsigned int MAX_SPEED_STEPS = (MAX_SPEED_mms *  STEPS_by_REV) / mm_by_REV;
const unsigned int HOME_SPEED_STEPS = (HOME_SPEED_mms *  STEPS_by_REV) / mm_by_REV;
const unsigned int HOME_INCREMENT_STEP = (HOME_INCREMENT_mm  *  STEPS_by_REV) / mm_by_REV;
const unsigned int HOME_PRESS_POSITION_STEP = (HOME_PRESS_POSITION_mm  *  STEPS_by_REV) / mm_by_REV;

//vars
unsigned int MaxPos_step =  (MAX_POS_mm *  STEPS_by_REV) / mm_by_REV;
bool CycleOn = true;
bool HomeDone = false;

void MotorGoHome(AccelStepper &stpr)
{
  int CurrentPos = 0;
  pc.printf("Finding Home...");
  stpr.setCurrentPosition(0);
  stpr.setMaxSpeed(HOME_SPEED_STEPS);
  while (HOM_PIN == HIGH)
  {
    CurrentPos = CurrentPos - HOME_INCREMENT_STEP;
    stpr.runToNewPosition(CurrentPos);
  }
  stpr.setCurrentPosition(0);
  stpr.runToNewPosition(HOME_PRESS_POSITION_STEP);
  stpr.setCurrentPosition(0);
  HomeDone = true;
  pc.printf("Finding Home...");
}

void setup(AccelStepper &stpr)
{
  pc.baud(250000);
  //pinMode(10  , OUTPUT);
  //pinMode(STP_PIN  , OUTPUT);
  //pinMode(DIR_PIN    , OUTPUT);
  //pinMode(ENA_PIN    , OUTPUT);
  ENA_PIN = HIGH; 
  stpr.setMaxSpeed(MAX_SPEED_STEPS);
  stpr.setAcceleration(MAX_ACCEL_STEPS2);
  MotorGoHome(stpr);
  stpr.setMaxSpeed(MAX_SPEED_STEPS);
  stpr.setAcceleration(MAX_ACCEL_STEPS2);
  //wdt_enable(WDTO_2S);
}

int main(){

    AccelStepper stepper(2, P1_2, P0_23);   
    
    setup(stepper);
    
    while(1){
        //wdt_reset();
        if (CycleOn)
        {
            if (stepper.currentPosition() == 0)
            {
                wait(500);
                stepper.moveTo(MaxPos_step);
            }
            else if (stepper.currentPosition() == MaxPos_step)
            {
                wait(500);
                stepper.moveTo(0);
            }
        }
        //analogWrite(10, map(stepper.currentPosition(), 0, MaxPos_step, 0, 250));
        stepper.run();
        if((HOM_PIN == LOW) && (HomeDone)) while(1);

        if (pc.readable())
        {
            char Option = pc.getc();
            if (Option == 'P')
            {
                //float NewPos = serial.parsefloat();
                //stepper.moveTo((NewPos *  STEPS_by_REV) / mm_by_REV);
            }
            else if (Option == 'C')
            {
                CycleOn = !CycleOn ;
            }
            else if (Option == 'S')
            {
                //float NewSpeed = parsefloat(); //pc.??
                //stepper.setMaxSpeed((NewSpeed *  STEPS_by_REV) / mm_by_REV);
            }
            else if (Option == 'H')
            {
                MotorGoHome(stepper);
            }
        }         
    }
    return 0;    
}
    