 #include "lora.h"
 #include "serial.h"
 
 
DigitalOut led1(P1_13);
DigitalOut led2(P1_14);

uint8_t buffer[255];
uint8_t message[255]; 
uint8_t message_pong[]="Pong";
uint8_t message_ping[]="Ping";

int e;
int cont =0;
uint8_t r_size;
int loraMode=LORAMODE;

 
 
 ////////////////////////////////////////
// SETUP SX1272 initialisation
////////////////////////////////////////
void setup()
{


    pc.printf("------Coragem LoRa temperature sensor -------------\n");
    //sx1272.ON();  // Power ON the module

    int error_config_sx1272=0;

    // Set transmission mode and print the result
    e = sx1272.setMode(loraMode);
    pc.printf("Mode: %d\n",loraMode);
    if (e) error_config_sx1272=1;
    pc.printf("Setting Mode: state %d\n",e);

    // enable carrier sense
    sx1272._enableCarrierSense=true;

    // for LOW POWER
    sx1272._RSSIonSend=false;


    // Select frequency channel
    e = sx1272.setChannel(DEFAULT_CHANNEL);
    if (e) error_config_sx1272=1;
    pc.printf("Setting Channel: state %d\n",e);

    // Select amplifier line; PABOOST or RFO
//    #ifdef PABOOST
//        printf("pabboost\n");
//        sx1272._needPABOOST=true;
//    // previous way for setting output power
//    // powerLevel='x';
//    #else
//    // previous way for setting output power
//    // powerLevel='M';
//    #endif

    // previous way for setting output power
    // e = sx1272.setPower(powerLevel);

    e = sx1272.setPowerDBM((uint8_t)MAX_DBM);
    if (e) error_config_sx1272=1;
    pc.printf("Setting Power: state %d\n",e);

    // Set the node address and print the result
    e = sx1272.setNodeAddress(node_addr);
    if (e) error_config_sx1272=1;
    pc.printf("Setting node addr: state %d\n",e);

    // Print a success message
    if (!error_config_sx1272) pc.printf("SX1272 successfully configured\n");
    else pc.printf("ERROR CONFIGURATION SX1272\n");

    wait_ms(400);
}
void send_packet (uint8_t *payload, uint8_t length8)   // envia pacote
{
     pc.printf("Samira - send_packet ( ) - ENTER..\n"); 

    //write on FIFO
    sx1272.writeRegister(REG_IRQ_FLAGS,255);//clear flags
    sx1272.writeRegister(REG_OP_MODE, LORA_STANDBY_MODE);  // Stdby LoRa mode to write in FIFO
    sx1272.writeRegister(REG_PAYLOAD_LENGTH_LORA, length8);
    sx1272.writeRegister(REG_FIFO_TX_BASE_ADDR,0x00);
    sx1272.writeRegister(REG_FIFO_ADDR_PTR,0x00);

    for(unsigned int i = 0; i <= length8; i++) {
         //  pc.printf("Samira - send_packet ( ) - FOR..\n"); 
        sx1272.writeRegister(REG_FIFO, payload[i]);  // Writing the payload in FIFO
    }

    //________________Send Data__________________
    sx1272.writeRegister(REG_IRQ_FLAGS,255);//clear flags
    sx1272.writeRegister(REG_OP_MODE, LORA_TX_MODE);  // LORA mode - Tx

    unsigned long exitTime = millis()+2000;//2 segundos para sair do for
    unsigned long Time= millis();
    char value = sx1272.readRegister(REG_IRQ_FLAGS);
/*
int bitCounter = 0; 
    while ((bitRead(value, 3) == 0) && (Time < exitTime)) {
        bitCounter ++;
           printf("bitCounter = %d", bitCounter); 
           printf("\n");
        value=sx1272.readRegister(REG_IRQ_FLAGS);
        Time= millis();
        wait_ms(50);
    }
  */  
    pc.printf("Samira - send_packet ( ) - OUT..\n");
   
 
    //wait_ms(50);

}

void send_data(int mode)  //data predefined
{
    led1=1;
    led2=1;
    pc.printf("Samira - enter send_data () ..\n"); 
    pc.printf("number=%d\n",cont);
    sx1272.writeRegister(REG_OP_MODE,129);//standby
    if (mode == DATA ) {
         pc.printf("Samira - send_data (DATA) ..\n"); 
         r_size=sprintf((char*)message,"111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111");
         send_packet(message,r_size);
         pc.printf("packet send :\n%s\nrsize=%d\n",message,r_size);
// //samira// it is sending sensors data 


        //============= internet of turtles =============
//        sprintf(float_breathing_time,"%04.2f", last_breathing_time);
//        sprintf(float_diving_time,"%04.2f", last_diving_time);
//        r_size=sprintf((char*)message,"\\!#Dt%04.2f_Bt%04.2f_%s°C_%shPa_%s%%",last_diving_time,last_breathing_time,float_temp,float_press,float_hum);
        // ==============================================

        //size=sprintf((char*)message,"\\!#%s°C_%shPa_%s%%",float_temp,float_press,float_hum);

 //       send_packet(message,r_size);
       // sx1272.sendPacketTimeout(DEFAULT_DEST_ADDR,/* (uint8_t*)*/message, r_size);
 //       printf("packet send :\n%s\nrsize=%d\n",message,r_size);


    } else if (mode == PING ) {

        printf("Samira - send_data (PING) ..\n"); 
        //sx1272.sendPacketTimeout(DEFAULT_DEST_ADDR, message_ping, sizeof(message_ping));
        send_packet(message_ping,sizeof(message_ping));
        pc.printf("packet sent : %s ",message_ping);
        pc.printf("packet size : %d \n",sizeof(message_ping));//samira//
        pc.printf("waiting for POng ... \n");


    } else if (mode == PONG )  {
        pc.printf("sending a PONG ... ");
        //sx1272.sendPacketTimeout(DEFAULT_DEST_ADDR, message_pong, sizeof(message_pong));
        send_packet(message_pong,sizeof(message_pong));
        pc.printf("packet send :\n%s\n",message_pong);
    }

    led1=0;
    led2=0;
    //wait_ms(300);

    sx1272.writeRegister(REG_IRQ_FLAGS,255);//clear flags
    sx1272.writeRegister(REG_OP_MODE,133); //leitura continua
    cont++;
}
void send_msg(char *msg_lora)  //data predefined
{
    led1=1;
    led2=1;

    sx1272.writeRegister(REG_OP_MODE,129);//standby 
         //send_packet((uint8_t*)msg_lora,strlen(msg_lora));
         //pc.printf("packet send :\n%s\nrsize=%d\n",msg_lora, strlen(msg_lora));
         //sx1272.sendPacketTimeout(DEFAULT_DEST_ADDR,/* (uint8_t*)*/msg_lora, strlen(msg_lora));
        r_size=sprintf((char*)message,msg_lora);
        pc.printf("packet send :\n%s\nrsize=%d\n",message,r_size);
        send_packet(message,r_size);

    led1=0;
    led2=0;

    sx1272.writeRegister(REG_IRQ_FLAGS,255);//clear flags
    sx1272.writeRegister(REG_OP_MODE,133); //leitura continua
    cont++;
}

void print_packet()
{

 pc.printf("Samira - print_packet () Enter ..\n"); 
    //led2=1;
    sx1272.writeRegister(REG_OP_MODE,129);//standby

    uint8_t pac_size;

    sx1272.writeRegister(REG_FIFO_ADDR_PTR,sx1272.readRegister(REG_FIFO_RX_CURRENT_ADDR));//set fifo pointer to read packet
    pac_size = sx1272.readRegister(REG_RX_NB_BYTES);//read size of packet
    pc.printf("Samira - print_packet () pac_size = %d ..\n", pac_size);
    pc.printf("<n");
    for(int i =0 ; i<pac_size ; i++) { //print packet
        buffer[i]=sx1272.readRegister(REG_FIFO);
      /*  if (buffer[i]== '\n')  printf(" \\n");
        if (buffer[i]== 0x0B)  printf("tab");*/
         pc.printf("%c",buffer[i]);//print packet
    }
    pc.printf(">\n");


    for(int i =0 ; i<pac_size ; i++) { //look for Ping in packet
        if ((buffer[i] =='P') && (buffer[i+1] =='i') && (buffer[i+2] =='n') && (buffer[i+3] =='g') ) {
            led1=1;
            led2=1;
            wait(1);
            sx1272.writeRegister(0x12,255);//clear flags
            led1=0;
            led2=0;
            pc.printf("There is a wait before sending PONG \n");
            pc.printf("sending PONG");
            send_data(PONG);
            i=pac_size;
        }
    }
    
        for(int i =0 ; i<pac_size ; i++) { //look for Pong in packet
        if ((buffer[i] =='P') && (buffer[i+1] =='o') && (buffer[i+2] =='n') && (buffer[i+3] =='g') ) {
            led1=1;
            led2=1;
            sx1272.writeRegister(0x12,255);//clear flags
            pc.printf("pong received \n");
            wait(1);
            led1=0;
            led2=0;
            
            i=pac_size;
        }
    }


    for(int i =0 ; i<pac_size ; i++) { //look for Reset in packet
        if ((buffer[i] =='R') && (buffer[i+1] =='e') && (buffer[i+2] =='s') && (buffer[i+3] =='e') && (buffer[i+4] =='t')  ) {
            uint32_t *ptr;
            ptr = (uint32_t *)1073743132;// endereço gpregret 0x4000051C
            *ptr = 0xB1;//BOOTLOADER_DFU_START
            NVIC_SystemReset();
        }
    }

    wait_ms(30);
    sx1272.writeRegister(REG_IRQ_FLAGS,255);//clear flags
    sx1272.writeRegister(REG_OP_MODE,133); //leitura continua
    led2=0;
     pc.printf("Samira - print_packet () OUT ..\n"); 

}