#ifndef _SHAREDOBJECT_H_
#define _SHAREDOBJECT_H_

#include "mbed.h"
#include "rtos.h"

/** Template class used to protect a shared resource with a Mutex.
 */
template <class T>
class SharedObject
{

    /** get/set controll mutex
     */
    Mutex _readwrite_mutex;

    /** value of the object
     */
    T _value;

public:

    /** Resource constructor.
     *  @param value sets the initial value of the resource.
     */
    SharedObject (const T& value)
    {
        _readwrite_mutex.lock();
        _value = value;
        _readwrite_mutex.unlock();
    }

    /** Resource constructor without initial value.
     */
    SharedObject ()
    {
        _readwrite_mutex.unlock();
    }

    /** Sets the specified value_destination with the value of the shared resource.
     */
    void get (T& value_destination) const
    {
        _readwrite_mutex.lock();
        value_destination = _value;
        _readwrite_mutex.unlock();
    }
    ///Returns the value of the shared resource (may be slower than get).
    operator T () const
    {
        T tmp_value;
        get(tmp_value);
        return tmp_value;
    }

    /** Sets the value of the shared resource with the specified new_value.
     */
    void set (const T& new_value)
    {
        _readwrite_mutex.lock();
        _value = new_value;
        _readwrite_mutex.unlock();
    }
    ///Alias of set.
    void operator= (const T& new_value)
    {
        set(new_value);
    }
};


#endif