#ifndef _REFRX_H_
#define _REFRX_H_

#include <stdint.h>
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

/** RefRX class used to receive pilot references with ethernet transmissions.
 *  Receive on internally managed UDP socket and controls the transmission
 *  with a TCP socket.
 */
class RefRX{
    static bool _initialized;
    
    static Mutex _refs_access;
    static float _ref1;
    static float _ref2;
    static float _ref3;
    static float _ref4;
    
    static int _listen_port;
    static int _destination_control_port;
    
    static Thread* _RX_thread;
    
  public:
    
    /** Thread procedure
     */
    static void worker (void const *args);
  
    /** Initialization procedure.
     *  @param listen_port
     *  @param destination_control_port remote port for the transmission control.
     *  @param ref1 pilot references to be overwritten.
     */
    static void init (const int listen_port, const int destination_control_port, Thread & worker_thread);
    
    /** Get references and store to parameters.
     *  Involves the use of a Mutex with trylock().
     */
    static bool get (float &ref1, float &ref2, float &ref3, float &ref4);
};

#endif