#include "RefRX.h"
#define REFRX_THREAD_START 1

// /////static members

bool RefRX::_initialized = false;

Mutex RefRX::_refs_access;
float RefRX::_ref1 = 0;
float RefRX::_ref2 = 0;
float RefRX::_ref3 = 0;
float RefRX::_ref4 = 0;

int RefRX::_listen_port = 0;
int RefRX::_destination_control_port = 0;

Thread* RefRX::_RX_thread = NULL;

// /////end of static members


bool RefRX::get (float &ref1, float &ref2, float &ref3, float &ref4)
{
    if(!_initialized)
        return false;
    bool lock = _refs_access.trylock();
    if(!lock)
        return false;
    
    ref1 = _ref1;
    ref2 = _ref2;
    ref3 = _ref3;
    ref4 = _ref4;
    
    _refs_access.unlock();
    return true;
}


void RefRX::init (const int listen_port, const int destination_control_port, Thread & worker_thread)
{
    if(_initialized)
        return;
    
    _listen_port = listen_port;
    _destination_control_port = destination_control_port;
    _RX_thread = &worker_thread;
    
    _initialized = true;
    
    _RX_thread->signal_set(REFRX_THREAD_START);
}


void RefRX::worker (void const *args)
{
    _RX_thread->signal_wait(REFRX_THREAD_START);

    //Setup RX socket
    UDPSocket sock;
    sock.bind(_listen_port);
    Endpoint remote_endpoint;
    
    DigitalOut led3 (LED3);
    led3 = 1;
    Thread::wait(1000);

    //Start listeing loop
    while(1)
    {
        const float one_over_uint32_max = 2.3283064365386963e-10;
        uint32_t refs[] =  { 0, 0, 0, 0};
        const unsigned int refs_size = 4 * sizeof(refs[0]);
        
        //listen for the values
        char in_buffer[256];
        int result = sock.receiveFrom(remote_endpoint, in_buffer, sizeof(in_buffer));
        
        switch (result) {
          case -1:
            //TODO: memorize error without the following message.
            //printf("Failed to read from UDP Socket\n\r");
            led3 = 0;
            break;
          case 0:
            // error ?
            led3 = 0;
            break;
          default:
            //socket.getRemoteEndpoint().getAddress().toString()
            //socket.getRemoteEndpoint().getPort());
            
            //retrive and share refs (convert to float)
            std::memcpy(refs,in_buffer,refs_size);
            _refs_access.lock();
            _ref1 = one_over_uint32_max * refs[0];
            _ref2 = one_over_uint32_max * refs[1];
            _ref3 = one_over_uint32_max * refs[2];
            _ref4 = one_over_uint32_max * refs[3];
            _refs_access.unlock();
            led3 = 0;
            Thread::wait(100);
            led3 = 1;
            
            //respond
            /*
            if (!socket.getRemoteEndpoint().getAddress().isEmpty()) {
                buffer.write("OK\r\n",4);
                socket.send(buffer, socket.getRemoteEndpoint());
            }*/
       }
    
        Thread::yield();
    }
}