#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"

Serial pc(USBTX, USBRX);
SLCD lcd;
TSISensor tsi; // touch sensor

bool send = true;
bool hit_right = false;
float speed = 0.2;

void send_ball_left(){
    lcd.clear();
    lcd.CharPosition=2; 
    lcd.putc('o');
    wait(speed);
    
    lcd.clear();
    lcd.CharPosition=1; 
    lcd.putc('o');
    wait(speed);
    
    lcd.clear();

}

void send_ball_right(){
    lcd.clear();
    lcd.CharPosition=0; 
    lcd.putc('o');
    wait(speed);
    
    lcd.clear();
    lcd.CharPosition=1; 
    lcd.putc('o');
    wait(speed);
    
    lcd.clear();
    lcd.CharPosition=2; 
    lcd.putc('o');
    wait(speed);
}

void send_ball_back(){
    
    lcd.clear();
    lcd.CharPosition=1; 
    lcd.putc('o');
    wait(speed);
    
    lcd.clear();
    lcd.CharPosition=2; 
    lcd.putc('o');
    wait(speed);
}

void check_swipe_left(){
    lcd.clear();
    lcd.CharPosition=3; 
    lcd.putc('o');
    wait(speed);
    
    if (tsi.readPercentage() > .75){
        send_ball_left();
        send = false;
        hit_right = true;
    }
    else {
        lcd.clear();
        lcd.CharPosition=1; 
        lcd.printf("no");
        wait(.7);
        send = true;
        hit_right = false;
        speed = speed + 0.01;
    }
}
        
void check_swipe_right(){
    lcd.clear();
    lcd.CharPosition=0; 
    lcd.putc('o');
    wait(speed);
    if (tsi.readPercentage() > .1 && tsi.readPercentage() < .5){
        send_ball_back();
        send = false;
        speed = speed - 0.01;
    }
    else {
        lcd.clear(); 
        lcd.printf("no");
        wait(.7);
        send = true;
        speed = speed + 0.01;
    }
}   
    
    


int main(void) {
     
     
     // initiate LCD
     lcd.Home();  
     
     while (true) {
        if (send) {send_ball_right();}
        check_swipe_left();
        if(hit_right){check_swipe_right();}
     }
}
