#include "mbed.h"
#include "C12832.h"

InterruptIn button(p14);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5, p7 ,p6, p8, p11);  // initilize lcd
Timer debounce;

int joystick;  // inilize integer value from p14

void flip()  {
    led = !led;  // toggles the led, when pressing a button connects ground to p14.
    }

int main() {
        debounce.start();
        button.rise(&flip);   // attach the function address to the rising edge (of p14)
        while(1)  {           // wait around, interrupts will interrupt this.
            flash = !flash;   // this just turns LED4 on and off every quarter second
            joystick = button; // ties joystick value to p14 condition
            if (joystick==1){ // test value of joystick               
            lcd.cls();  // clear lcd screen
            lcd.locate(2,2);  // sets start location for print text
            lcd.printf("joystick pressed");  // print instruction
            wait(0.25);
            }
            else{              
            lcd.cls();  // clear lcd screen
            lcd.locate(2,12); // sets start location for print text
            lcd.printf("joystick is not pressed ");
            wait(0.25);       // this is the instruction to wait for a quarter second
            if (debounce.read_ms()>10)
            debounce.reset();
           }
           
    }
}
