#include "mbed.h"
#include "SDFileSystem.h"
#include "DOGM_STREAM_SPI.h"

DogM lcd(p11, p12, p13, p8, p9, p10); // mosi, miso, sclk, rs, csb, res
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
 
int main() {
    printf("Hello World!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    printf("Goodbye World!\n");


    wait(0.1);

    lcd.cls();
    lcd.c_off();
    lcd.printf("Hello World!\n");
    wait(1.0);
    lcd.printf("Hei verden! %d\n", 1);
    wait(1.0);
    lcd.printf("Hallo Welt! %c\n", 'hk');
    wait(2.0);
    lcd.cls();
    lcd.puts("PUTS");
    wait(2.0);
 
    while(1) { // Løpelys med bokstaven 'P' over 3 rader
        for (int j = 0; j < 16; j++) {
            for (int i = 0; i < 3; i++) {
                lcd.locate(j, i);
                lcd.putc('P');

                wait(0.1);
                lcd.locate(j, i);
                lcd.putc(' ');
            }
        }
    } 
}
