#include "mbed.h"

class DogM : public Stream {
public:
    DogM(PinName mosi, PinName miso, PinName sclk, PinName _rs_, PinName _csb_, PinName _res_);

    //int putc(int c);
    //int printf(const char* format, ...);

    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(int column, int row);
    void cls();

    void blank(void);
    void home(void);
    void upper(void);
    void middle(void);
    void lower(void);
    void chr(uint8_t c);
    void out(char *s);
    void line(uint8_t line, uint8_t pos, char *s);
    void pos(uint8_t line, uint8_t pos);
    void c_off(void);
    void c_on (void);
    void c_blink(void);
    void c_left(void);
    void c_right(void);

protected:
    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();

    int address(int column, int row);
    void character(int column, int row, int c);

    int _column;
    int _row;
    int _columns;
    int _rows;

private:
    SPI dogm; // mosi, miso, sclk
    DigitalOut rs;
    DigitalOut csb;
    DigitalOut res;

    void data(uint8_t d);
    void command(uint8_t c);
};