#include "DOGM_STREAM_SPI.h"

DogM::DogM(PinName mosi, PinName miso, PinName sclk, PinName _rs_, PinName _csb_, PinName _res_) :
        dogm(mosi, miso, sclk), rs(_rs_), csb(_csb_), res(_res_) {

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    dogm.format(8,0);
    dogm.frequency(100000); // Also working with 1MHz

    // RESETTING DOGM MODULE
    res = 0;
    wait_ms(10);
    res = 1;
    wait_ms(10);
    res = 0;
    wait_ms(40);
    res = 1;
    wait_ms(10);

    //command(0x39); // FUNCTION SET
    //wait_ms(40);

    // FROM DOGM DATABLAD - OPPSETT FOR 3 LINJER 3.3 V

    command(0x39); // FUNCTION SET
    wait_us(100);

    command(0x15); // BIAS SET
    wait_us(50);

    command(0x55); // POWER CONTROL
    wait_ms(200);

    command(0x6E); // FOLLOWER CONTROL
    wait_ms(200);

    command(0x72); // CONTRAST SET
    wait_ms(50);

    command(0x38); // FUNCTION SET
    wait_us(50);

    command(0x0F); // DISPLAY ON/OFF
    wait_us(50);

    command(0x01); // CLEAR DISPLAY
    wait_us(50);

    command(0x06); // ENTRY MODE SET
    wait_us(50);

    _rows = 3;
    _columns = 16;
}


void DogM::data(uint8_t c) {
    csb = 0;
    wait_us(1);
    rs = 1;
    wait_us(1);
    dogm.write(c);
    wait_us(1);
    csb = 1;
    wait_us(40); // Default delay
}

void DogM::command(uint8_t c) {
    csb = 0;
    wait_us(1);
    rs = 0;
    wait_us(1);
    dogm.write(c);
    wait_us(1);
    csb = 1;
    wait_us(40); // Default delay
}

void DogM::blank() {
    command(0x01);
    wait_us(2000);
}

void DogM::home() {
    command (0x02);
    wait_us(2000);
}

void DogM::upper() {
    command (0x80);
}

void DogM::middle() {
    command (0x90);
}

void DogM::lower() {
    command (0xA0);
}

void DogM::chr(uint8_t c) {
    data(c);
}

void DogM::out(char *s) {
    while (*s) {
        data(*s++);
    }
}

void DogM::line(uint8_t column, uint8_t row, char *s) {
    command(address(column, row));
    for (int i = column; i < _columns; i++) {
        if (*s != '\0') {
            data(*s);
            s++;
        } else {
            data(' ');
        }
    }
}

// Upper line = 0, middle line = 1, lower line = 2
// First position on line is 0 - last is 15
void DogM::pos(uint8_t column, uint8_t row) {
    uint8_t adress;
    switch (row) {
        case 1:
            adress = 0x10;
            break;
        case 2:
            adress = 0x20;
            break;
        default:
            adress = 0x00;
            break;
    }
    adress += (column + 0x80);
    _row = row;
    _column = column;
    command (adress);
}

void DogM::c_off() {
    command (0x0C);
}
void DogM::c_on () {
    command (0x0E);
}

void DogM::c_blink() {
    command (0x0F);
}

void DogM::c_left() {
    command (0x10);
}

void DogM::c_right() {
    command (0x14);
}

// COPIED FROM TxtLCD class

void DogM::character(int column, int row, int c) {
    int a = address(column, row);
    command(a);
    data(c);
}

void DogM::cls() {
    command(0x01);    // cls, and set cursor to 0
    wait(0.00164f);   // This command takes 1.64 ms
    locate(0, 0);
}

void DogM::locate(int column, int row) {
    _column = column;
    _row = row;
}

int DogM::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= _rows) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= _columns) {
            _column = 0;
            _row++;
            if (_row >= _rows) {
                _row = 0;
            }
        }
    }
    return value;
}

int DogM::_getc() {
    return -1;
}

int DogM::address(int column, int row) {
    return 0x80 + (row * 0x10) + column;
}

