#include "mbed.h"
#include "config.h"
#include "communication.h"
#include "T_H_air.h"
#include "T_H_soil.h"
#include "altitude.h"
#include "HMC5883L.h"

DS1820 probe(SOIL_T_PIN);
AnalogIn humidSensor(SOIL_H_PIN);
Serial wisol(SERIAL_PORT);
Serial pc(USBTX, USBRX);
DHT sensor(PIN_NAME, DHTtype);
HP20x_dev barometre(HP20X_I2C_PORT);
HMC5883L hmc5883(HMC5883_I2C_PORT);

int main()
{
    float airH = 0,airT = 0, solT = 0, solH = 0;;
    long P = 0;
    float airValue(AIR_SOIL_HUMIDITY);
    float waterValue(WATER_SOIL_HUMIDITY);
    char* msg;


    if(initSoilTemp(probe,SOIL_T_PIN)) {
        pc.printf("unassigned Probe\r\n");
    }
    barometre.reset();
    while(1) {
        float temp = 0;
        int16_t magXYZ[3];
        //collect data
        hmc5883.getXYZ(magXYZ);
        get_T_H_air(&airT, &airH, sensor); // takes 2s to execute
        P = pression(&barometre); // takes 5s to execute
        temp = getSoilTemperature(probe);
        if(temp == DS1820::invalid_conversion) {
            pc.printf("Error with soil temperature probe : not connected\n\r");
        }
        else{
            solT = temp;
            }
        solH = getSoilHumidity( humidSensor, airValue,waterValue, true);
        
        msg = genMessage( solH,  airH,  solT, airT, P,magXYZ);
        // Display
        pc.printf("\n\r=====| Data |=====\n\r");
        pc.printf("H sol : %.2f %%\r\n", solH);
        pc.printf("H air : %.2f %%\r\n", airH);
        pc.printf("T sol : %.2f C\r\n", solT);
        pc.printf("T air : %.2f C\r\n", airT);
        pc.printf("Mag : X:%d ; Y:%d ; Z:%d\n\r", magXYZ[0], magXYZ[1], magXYZ[2]); 
        pc.printf("Pression : %u Pa\r\n", P);
        pc.printf("AT$SF=%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\r\n", msg[0], msg[1], msg[2], msg[3], msg[4], msg[5], msg[6], msg[7], msg[8], msg[9], msg[10], msg[11]);
        //wisol.printf("AT$SF=%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x\r\n", msg[0], msg[1], msg[2], msg[3], msg[4], msg[5], msg[6], msg[7], msg[8], msg[9], msg[10], msg[11]);
        pc.printf("\n\r");
        free(msg);
        msg = NULL;
        wait(3);
        //wait(WAIT_TIME - 7);
    }
}
