#ifndef __CONFIG__
#define __CONFIG__

// communication
#define SERIAL_PORT                 D1, D0 // Rx <-> Tx     |       Tx <-> Rx
#define WAIT_TIME                   60*15 // 15 minutes

// T_H_air
#define PIN_NAME                    D6
#define DHTtype                     DHT22

// T_H_soil
#define AIR_SOIL_HUMIDITY           0.78 // dry dirt at 0.75 with AnalogIn.read()
#define WATER_SOIL_HUMIDITY         0.38 // wet dirt at 0.54
#define SOIL_T_PIN                  A4
#define SOIL_H_PIN                  A3 // max: 0.77 min:0.38

// Altitude
#define HP20X_I2C_DEV_ID            0xEC
#define HP20X_I2C_PORT              D12, A6

// Magnetometer
#define HMC5883_I2C_PORT            D4, D5 //sda, scl

// Warnings
#define W_AIR                       LED3

// Voltage control
#define TRANSISTOR_ALTITUDE_PIN     A0
#define TRANSISTOR_GENERAL_PIN      D3

// OLED screen
#define MISO                        NC
#define MOSI                        D2
#define CLK                         D9
#define DC                          D10
#define RST_SPI                     D11
#define CS                          A7

#endif