#ifndef T_H_SOIL_H
#define T_H_SOIL_H

#include "mbed.h"
#include "DS1820.h"
 
//#define   AIR_SOIL_HUMIDITY 0.78 // dry dirt at 0.75 with AnalogIn.read()
//#define WATER_SOIL_HUMIDITY 0.38 // wet dirt at 0.54


bool initSoilTemp(DS1820 probe, PinName pin);

float getSoilTemperature(DS1820& probe);//can return DS1820::invalid_conversion

float getSoilHumidity(AnalogIn& probe, 
                      float& airValue, 
                      float& waterValue, 
                      bool adaptiveCalibration = true);
/* ## EXAMPLE
#include "mbed.h"
#include "T_H_soil.h"

DS1820 probe(PA_5);//A4
Serial pc(USBTX, USBRX);
AnalogIn humidSensor(PA_6);// A5 // max: 0.77 min:0.38

int main() {
    if(initSoilTemp(probe,PA_5))
            pc.printf("unassigned Probe\r\n");
    float airValue(AIR_SOIL_HUMIDITY);
    float waterValue(WATER_SOIL_HUMIDITY);
    while(1) {
        float humid = getSoilHumidity( humidSensor, airValue,waterValue, true);
        float temp  = getSoilTemperature(probe);
        
        if(temp == DS1820::invalid_conversion)
            pc.printf("Error with soil temperature probe : not connected\n\r");
            
        pc.printf("Soil ## T:%.2foC ## H :%.2f%% V:%f ##\r\n", temp, humid,humidSensor.read());
        
        wait(0.1);
    }
}
*/
#endif