#include "T_H_soil.h"

bool initSoilTemp(DS1820 probe, PinName pin)
{
    //check that a DS1820 is connected at its port and init it
    return probe.unassignedProbe(pin);
}

float getSoilTemperature(DS1820& probe)
{
    bool wait(true);// if true, waits up to 750ms before returning(based on wented precision)
    //return the ms_delay until the conversion will complete (=0 if wait == true)
    int ms_delay = probe.convertTemperature(wait, DS1820::this_device);
    if(ms_delay > 0)
        wait_ms(ms_delay);
        
    //grab and return the conversion result
    return probe.temperature();
    //can return DS1820::invalid_conversion
}

float getSoilHumidity(AnalogIn& probe, float& airValue, float& waterValue, bool adaptiveCalibration)
{
        float HumidSensorVal = probe.read();
        float onePercent = (airValue - waterValue)/100;
        float humidityPercentage = 100-(HumidSensorVal-waterValue)/onePercent;
        if(humidityPercentage < 0 && adaptiveCalibration)// in case its drier than we expected at max
        {
            humidityPercentage = 0;
            airValue = HumidSensorVal;
        }
        else if(humidityPercentage > 100 && adaptiveCalibration)// in case its wetter than we expected at max
        {
            humidityPercentage = 100;
            waterValue = HumidSensorVal;
        }
    return humidityPercentage;
}