#include "mbed.h"
#include "communication.h"

char *genMessage(float h_sol, float h_air, float t_sol, float t_air, long pression, int16_t *chMag) {
    char *m;
    m = (char*)malloc(12*sizeof(char));
    m[0] = ((char)h_sol) << 1; // b0 --- b6
    m[0] = m[0] + (((char)h_air) >> 6); // b7
    m[1] = ((char)h_air) << 2; // b8 --- b13
    m[1] = m[1] + (((int)(t_sol * 10) + 200) >> 8); // b14 --- b15
    m[2] = ((int)(t_sol * 10) + 200) & 0x0ff; // b16 --- b23
    m[3] = (((int)(t_air * 10) + 200) >> 2) & 0xff; // b24 --- b31
    m[4] = (((int)(t_air * 10) + 200) & 0x03) << 10; // b32 --- b33
    m[4] = m[4] + ((chMag[0] & 0x3ff) >> 4); // b34 --- b39
    m[5] = chMag[0] & 0xf; // b40 --- b43
    m[5] = m[5] + ((chMag[1] & 0x3ff) >> 6); // b44 --- b47
    m[6] = (chMag[1] & 0x3f) << 2; // b48 --- b53
    m[6] = m[6] + (chMag[2] & 0x3ff) >> 8; // b54 --- b55
    m[7] = chMag[2] & 0xff; // b56 --- b63
    m[8] = (char)((pression & 0xff0000) >> 16); // b64 --- b71
    m[9] = (char)((pression & 0x00ff00) >> 8); // b72 --- b79
    m[10] = (char)(pression & 0x0000ff); // b80 --- b87
    //m[11] = '\0';
    return m;
}