#include "mbed.h"
#include "datos.h"

Serial pc(SERIAL_TX, SERIAL_RX);
SPI deviceM(PA_7, PA_6, PA_5);
DigitalOut ssel (PA_4);


#define  uint8_t unsigned char
uint8_t screen[8]={0,0,0,0,0,0,0,0};
uint8_t screen2[8]={0,0,0,0,0,0,0,0};
uint8_t verifica;
uint8_t mascara;
int velocidad=70;
int segundo=1;

///////////////////////////////////////////////////////////////////////////////
void sendSPI(uint8_t d1, uint8_t d2)// envio de datos al max
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};
///////////////////////////////////////////////////////////////////////////////
void borrar()    // Borrar todos los datos de la matriz
{
   int j;
     for(j=1;j<9;j++)
     {
      sendSPI(j,0);
      wait_ms(1);
     }
}
///////////////////////////////////////////////////////////////////////////////
void enviar()   // Encargado de enviar la matriz completa
{
   int i;
 
      for(i=0;i<8;i++)
      {
       sendSPI(i+1,screen[i]);      
      }    
}   
///////////////////////////////////////////////////////////////////////////////
void ver()      //  Informe de datos "no se usa "
{
 int i;
       for(i=0;i<8;i++)
       {
         pc.printf("posicion %d ",i);
         pc.printf("=  %d \n",screen[i]);     
       }      
}  
///////////////////////////////////////////////////////////////////////////////
void escribir()   // Guarda y compara los datos entrantes a la matriz y los que ya estaban
{
int i;
 
     for(i=0;i<tamano;i++)
     {
         screen2[posicion-i]=(start[posicion-i] & 128);
         start[posicion-i]=start[posicion-i] << 1;
     }   
     
     //pc.printf("1 \n");
     //ver();
     
     
     for(i=0;i<tamano;i++)
     {
         screen[posicion-i]=((((screen[posicion-i]>>1) & ~(mascara-1)) | (screen[posicion-i] & (mascara-1))) | screen2[posicion-i] ) | (screen[posicion-i] & mascara) | (screen[posicion-i] & mascara*segundo);
     }    
     
     //pc.printf("2 \n");
     //ver();
     enviar();
}    
///////////////////////////////////////////////////////////////////////////////
int ubicacion()            //Limita el ingreso de posicion no mayor a 7
{
    int a;
    if((posicion_original+tamano) <= 8 && (posicion_original+tamano) >= 0  )
    {
      a=1;
    }
    else
    {
      //pc.printf("Error de posicion \n");
      //pc.printf("Posicion original %d \n",posicion_original);
      //pc.printf("tamano  %d \n",tamano);
      a=0;
    }    
    return a;
}
///////////////////////////////////////////////////////////////////////////////
void analisis()  // Verifica la siguiente fila para saber si se puede desplazar 
{
int i;
uint8_t a;
       
       for(i=0;i<tamano;i++)
       {
            a=screen[posicion-i] & mascara;
         // pc.printf("verificacion siguiente fila = %d \n ",a);
            if(mascara==a)
            {
             i=tamano;
             verifica=1;
            }  
            else
            {
             verifica=0;     
            }
       }    
}     
////////////////////////////////////////////////////////////////////////////////
void analisis2()   // Prueba 
{
    int i;
    uint8_t a;
       
       for(i=0;i<tamano;i++)
       {
            a=screen[posicion-i] & mascara;
            a= a & ((screen[posicion-i]>>1) & ~(mascara - 1));  
            pc.printf("verificacion siguiente fila = %d \n ",a);
            if(a!=0)
            {
             i=tamano;
             verifica=1;
             segundo=1;
             if(verificar2==1)
             {
                 verificar2=0;
                 verifica=0;
                 segundo=2;
             }   
            }  
            else
            {
             segundo=1;
             verifica=0;     
            }
       }    
    
}
///////////////////////////////////////////////////////////////////////////////
void play ()  // Funcion encargada de determianr el estado de la mascara
{
 int a=1;
  mascara=128;
  //pc.printf("Posicion original 1 %d \n",posicion_original);
  a=ubicacion();
    while(a==1)
    {
     analisis2();
          
        if (verifica==1 || mascara==0)
        {
         a=0;
         //pc.printf("SI  \n");
        }
        else 
        {
         //pc.printf("NO  \n");
         escribir();  
         mascara=mascara/2; 
         wait_ms(velocidad);
         //pc.printf("_____________________\n\n");
        }
    }            
}

///////////////////////////////////////////////////////////////////////////////
          
int main() { // fucnion principal 

        sendSPI(0x0c,1);
        sendSPI(0x0F,1);
        wait (1);
                    
        sendSPI(0x0F,0);
        wait (1);
        sendSPI(0xB,0x7);
        borrar();
                    
        int n;
        int giro, inicio , fin;
          while(1){
           
           inicio=pc.getc();
           //pc.printf("Ingrese el numero de la figura \n");
           n = pc.getc();  
           //pc.printf("figura  %d \n ",n);
                                       
           //pc.printf("Ingrese el numero de angulo de giro \n");
           giro = pc.getc();
           //pc.printf("giro %d \n ",giro);
                       
           //pc.printf("Ingrese la posicion  \n");
           posicion = pc.getc();
           //pc.printf("posicion %d \n ",posicion);  
            
            fin=pc.getc();           
           wait(0.2);
                       
                       if((inicio==60) && (fin==62))
                       {
                       
                       switch(n)
                       {
                         case 0: a(giro); play(); break;  
                                                  
                         case 1: b(giro); play(); break;  
                         
                         case 2: c(giro); play(); break;  
                         
                         case 3: d(giro); play(); break;  
                         
                         case 4: e(giro); play(); break;  
                         
                         case 5: f(giro); play(); break;  
                         
                         case 6: g(giro); play(); break;  
                          
                        default: pc.printf("Error en figura \n");                           
                      }
                     }      
         }                
}
