#include "mbed.h"
#include "datos.h"
 
Serial pc(SERIAL_TX, SERIAL_RX);
SPI deviceM(PA_7,PA_6, PA_5);
DigitalOut ssel (PA_4);
//InterruptIn girop(PF_1);
//InterruptIn posicionmas(PF_0);
//InterruptIn posicionmenos(PA_8);
 void Rx_interrupt();
 
#define  uint8_t unsigned char
uint8_t screen[8]={0,0,0,0,0,0,0,0};
uint8_t screen2[8]={0,0,0,0,0,0,0,0};
uint8_t verifica;
uint8_t mascara,mascarax;
int velocidad, pieza,giro;
uint8_t cambio;

///////////////////////////////////////////////////////////////////////////////
void sendSPI(uint8_t d1, uint8_t d2)// envio de datos al max
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock();
};

///////////////////////////////////////////////////////////////////////////////
void borrar()    // Borrar todos los datos de la matriz
{
   int j;
     for(j=1;j<9;j++)
     {
      sendSPI(j,0);
      wait_ms(1);
     }
}
///////////////////////////////////////////////////////////////////////////////
void escribir()   // Guarda y compara los datos entrantes a la matriz y los que ya estaban
{
int i,j;
 
     for(i=0;i<tamano;i++)
     {
         screen2[posicion-i]=(start[posicion-i] & 128);
         start[posicion-i]=start[posicion-i] << 1;
     }   
     
     for(i=0;i<tamano;i++)
     {
         screen[posicion-i]=((((screen[posicion-i]>>1) & ~(mascara-1)) | (screen[posicion-i] & (mascara-1))) | screen2[posicion-i] ) | (screen[posicion-i] & (mascara));
     }    
     //enviar
     for(j=0;j<8;j++)
      {         
       sendSPI(j+1,screen[j]); 
       //pc.printf(" posicion %d",j);
       //pc.printf("--> %d \n",screen[j]);
      }
      //pc.printf("----------\n");
}    
///////////////////////////////////////////////////////////////////////////////
int ubicacion()            //Limita el ingreso de posicion no mayor a 7
{
    int a;
    if((posicion_original+tamano) <= 8 && (posicion_original+tamano) >= 0  )
    {
      a=1;
    }
    else
    {
      a=0;
    }    
    return a;
}
///////////////////////////////////////////////////////////////////////////////
void analisis()  // Verifica la siguiente fila para saber si se puede desplazar 
{
int i;
uint8_t a;
       
       for(i=0;i<tamano;i++)
       {
            a=screen[posicion-i] & mascara;
            a= a & ((screen[posicion-i]>>1) & ~(mascara-1));
           
            if(mascara==a)
            {
             i=tamano;
             verifica=1;
            }  
            else
            {
            verifica=0;       
            }
       }  
} 
//////////////////////////////////////////////////////////////////////////////
void nuevo () //pide nuevamente los datos de la pieza con los cambios de giro o posicion
{
   int k;
  
    for(k=0;k<tamano;k++)//borra la pieza que habia 
    {   
      screen[posicion-k]=screen[posicion-k]&(mascara-1);
    }
    mascara=128;//se coloca 128 para que baje completa la pieza
    tamano=0;
    posicion=posicion_original;
        
        switch(pieza)//vuelve a colocar los datos de la pieza con los cambios
             {                          
                   case 0: a(giro);   break;                       
                   case 1: b(giro);   break;  
                   case 2: c(giro);   break; 
                   case 3: d(giro);   break;  
                   case 4: e(giro);   break;  
                   case 5: f(giro);   break; 
                   case 6: g(giro);   break;  
                   default: pc.printf("Error en figura \n");
             } 

}         
//////////////////////////////////////////////////////////////////////////////
int analisis2()//INTENTO DE RESTRINGIR EL GIRO
{   
   int b;
   
   if(mascara<=((screen[posicion-1])+1) || mascara<=((screen[posicion+tamano])+1))  
   {
      b=0;
   } 
   else 
   {
      b=1;
   }
   
   return b;
}    
//////////////////////////////////////////////////////////////////////////////
void giros() //interrupcion cuando se oprime el boton de giro 
{
 int girox,posicionx;
 int a=1;
 int b=1;
 
 cambio=1;//entra al cambio de velocidad para la visualizacion dinamica
 mascarax=mascara;   //guarda la posicion de donde estaba la pieza que es hasta donde se debe hacer la visualizacion 
 girox=giro;
 posicionx=posicion_original;
                
   giro=giro+1;
   if(giro>=4) giro=00;//limita el giro 
   b=analisis2();//LA IDEA ES QUE AQUI ANALICE SI PUEDE GIRARSE
   nuevo();//se  pide esta funcion para que antes de hacer el analisis de ubicacion coloque los datos nuevos teniendo en cuenta que si sa cambia el giro cambia el tamano
   a=ubicacion();
   if (a==0 | b==0)///cuando esta fuera de los limites vuelve a mandar los mismos datos de la pieza que estaba
   {
     giro=girox;
     posicion_original=posicionx;
  }
  nuevo();   //se pide esta funcion nuevamente porque en dado caso de que no este en lo limites se vuelvan a enviar los mismos datos
  
  wait_ms(700);
}
//////////////////////////////////////////////////////////////////////////////
void pmenos()    //interrupcion de poscion menos
{
  int girox,posicionx;
  int a=1;
  int b=1;

  cambio=1;//entra al cambio de velocidad para la visualizacion dinamica
  mascarax=mascara;   //guarda la posicion de donde estaba la pieza que es hasta donde se debe hacer la visualizacion 
  girox=giro;
  posicionx=posicion_original;

  posicion_original=posicion_original-1;
  b=analisis2();//LA IDEA ES QUE AQUI ANALICE SI PUEDE CORRERSE 
  a=ubicacion();
  if (a==0 | b==0)//cuando esta fuera de los limites vuelve a mandar los mismos datos de la pieza que estaba
  {
     giro=girox;
     posicion_original=posicionx;
  }
  nuevo();// solo se solicita una vez esta funcion ya que lo unico que varia es la posicion 
  wait_ms(500);
}    
//////////////////////////////////////////////////////////////////////////////
void pmas() //interrupcion posicion mas
{
  int girox,posicionx;
  int a=1;
  int b=1;
  
  cambio=1;//entra al cambio de velocidad para la visualizacion dinamica
  mascarax=mascara; //guarda la posicion de donde estaba la pieza que es hasta donde se debe hacer la visualizacion  
  girox=giro;
  posicionx=posicion_original;
  
  posicion_original=posicion_original+1;  
  b=analisis2();//LA IDEA ES QUE AQUI ANALICE SI PUEDE CORRERSE
  a=ubicacion();
  
  if (a==0 | b==0)//cuando esta fuera de los limites vuelve a mandar los mismos datos de la pieza que estaba
  {
      giro=girox;
      posicion_original=posicionx;
  }
  nuevo();
  wait_ms(500);
}
//////////////////////////////////////////////////////////////////////////////
void play ()  // Funcion encargada de determinar el estado de la mascara
{
cambio=0;
int a=1;
mascara=128;
velocidad=1;
a=ubicacion();

    while(a==1)
    {   
        analisis();
          
        if (verifica==1)a=0;
        else 
        {   
                             
           if(cambio==1)//cambio de velocidad para poder hacer visualizacion dinamica cada vez que se presiona un pulsador
            {
                if(mascarax!=mascara)velocidad=0;//mientras cae a la posicion que estaba va a tener esta velocidad
                else 
                {
                    velocidad=1;  
                    cambio=0;
                 }   
            } 
            else velocidad=1;
            
           // girop.rise(&giros);//interrupcion giro
            //posicionmenos.rise(&pmenos);//interrupcion posicion menos
            //posicionmas.rise(&pmas);//interrupcion posicion mas
            
            escribir();  
            mascara=mascara/2; 
            wait(velocidad);
            }
    }     
}
///////////////////////////////////////////////////////////////////////////////         
int main() { // fucnion principal 
 
        pc.baud(9600);
        pc.attach(&Rx_interrupt, Serial::RxIrq);
 
        sendSPI(0x0c,1);
        sendSPI(0x0F,1);
        wait (1);
                    
        sendSPI(0x0F,0);
        wait (1);
        sendSPI(0xB,0x7);
        borrar();
        int inicio,fin; 
        
          while(1){
           //pide los datos por el serial
           inicio=60;                  
           pieza=10;

  
           while( pieza>6)
           {
             pieza=rand ()% 16;
             pc.printf("%d ",pieza);
            }
           posicion=3;
           giro = 0;
             
           fin=62;          
                       
                       if((inicio==60) && (fin==62))
                       {
                               switch(pieza)
                               {                          
                                      case 0: a(giro); play();  break;                       
                                      case 1: b(giro); play();  break;  
                                      case 2: c(giro); play();  break; 
                                      case 3: d(giro); play();  break;  
                                      case 4: e(giro); play();  break;  
                                      case 5: f(giro); play();  break; 
                                      case 6: g(giro); play();  break;  
                                      default: pc.printf("Error en figura \n");
                               }     
                        }                       
         } 
} 


void Rx_interrupt() {
 
    char d = pc.getc();
    pc.printf("numero %d\n",d);
    
    
    switch(d)
    {
      case 97:  pmenos(); break;
      case 100: pmas(); break;
      case 119: giros(); break;
       default: pc.printf("Error  \n");
        
     }   

    return; 
}