#include "mbed.h"

DigitalIn boton(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);
I2C i2c(PB_9, PB_8 );

const int addr = 0xD0;      // 7 bit I2C address
char cmd[2];
char read_buffer[14];

int16_t acc_x = 0, acc_y = 0, acc_z = 0;
int16_t gyr_x = 0, gyr_y = 0, gyr_z = 0;
int16_t temp = 0;

float ACC_SEN = 16384.0;    //Resolución ACC
float GYR_SEN = 131.0;      //Resolución GYR
float TEM_SEN = 340.0;      //Resolución temp

float facc_x = 0, facc_y = 0, facc_z = 0;
float fgyr_x = 0, fgyr_y = 0, fgyr_z = 0;
float ftemp = 0;


int cont=0;
int i,j;
int limite;
int limite1;

Timer tiempo;
int val_tiempo;

float memoria[501][8];
unsigned int cont_m=1;

DigitalOut myled(LED1);


void lec_escritura (void);

int main()
{

    pc.baud(115200);

    pc.printf("Prueba MPU6050 \n\r");

    cmd[0] = 0x6B;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //Desactivar modo hibernación

    cmd[0] = 0x1B;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //gyro full scale 250 DPS

    cmd[0] = 0x1C;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //ACC fullsclae 2G


//////////////////////////////////////////////////////////////////////
// determinacion de tiempos con timer 
 
 /*
 while(1)
 {
 
 tiempo.reset();
 tiempo.start();
 lec_escritura();
 
 val_tiempo=tiempo.read_us();
 pc.printf("Tiempo en us es= %d  \n\r",val_tiempo);

 tiempo.reset();
}
*/



////////////////////////////////////////////////////////////////////////////////
    //pc.printf("Inicializando \n");
    while(1) {
        if(boton==0 && cont==0) {
            cont_m=1;
            while(boton==0);

            for(cont_m=1; cont_m<=100; cont_m++) {
                lec_escritura();
            }
            for(int i=1; i<=100; i++) {

                pc.printf("Registro # %d  ACCx = %.2f ACCy = %.2f ACCz = %.2f  GYRx = %.2f GYRy = %.2f GYRz = %.2f  Temp = %.2f \n\r",i,memoria[i][1],memoria[i][2],memoria[i][3],memoria[i][4],memoria[i][5],memoria[i][6],memoria[i][7]);
            }
            cont=1;
        }


        if(boton==0 && cont==1) {
            cont_m=1;
            while(boton==0);

            for(cont_m=1; cont_m<=500; cont_m++) {
                lec_escritura();
            }
            for(int i=1; i<=500; i++) {

                pc.printf("Registro # %d  ACCx = %.2f ACCy = %.2f ACCz = %.2f  GYRx = %.2f GYRy = %.2f GYRz = %.2f  Temp = %.2f \n\r",i,memoria[i][1],memoria[i][2],memoria[i][3],memoria[i][4],memoria[i][5],memoria[i][6],memoria[i][7]);
            }
            cont=0;
        }

    }
}

void lec_escritura(void)

{

    //wait_ms(10);

    cmd[0]=0x3B;
    i2c.write(addr, cmd, 1);            //Escritura del registro de inicio
    i2c.read(addr, read_buffer, 14);    //Lectura en rafaga de los valores de la MPU

    //.................Construcción de la medición de los valores ..................
    acc_x = read_buffer[0]<<8 | read_buffer[1];
    acc_y = read_buffer[2]<<8 | read_buffer[3];
    acc_z = read_buffer[4]<<8 | read_buffer[5];
    temp  = read_buffer[6]<<8 | read_buffer[7];
    gyr_x = read_buffer[8]<<8 | read_buffer[9];
    gyr_y = read_buffer[10]<<8 | read_buffer[11];
    gyr_z = read_buffer[12]<<8 | read_buffer[13];


    //pc.printf("ACCx = %i ACCy = %i ACCz = %i \n\r", acc_x, acc_y, acc_z);

    facc_x = acc_x/ACC_SEN;
    facc_y = acc_y/ACC_SEN;
    facc_z = acc_z/ACC_SEN;

    //pc.printf("ACCx = %.2f ACCy = %.2f ACCz = %.2f \n\r", facc_x, facc_y, facc_z);

    fgyr_x = gyr_x/GYR_SEN;
    fgyr_y = gyr_y/GYR_SEN;
    fgyr_z = gyr_z/GYR_SEN;


    ftemp= (temp - 521)/TEM_SEN;

    // pc.printf("Registro # %d  ACCx = %.2f ACCy = %.2f ACCz = %.2f  GYRx = %.2f GYRy = %.2f GYRz = %.2f  Temp = %.2f \n\r",i, facc_x, facc_y, facc_z, fgyr_x, fgyr_y, fgyr_z,ftemp);

    memoria[cont_m][1]=facc_x;
    memoria[cont_m][2]=facc_y;
    memoria[cont_m][3]=facc_z;
    memoria[cont_m][4]=fgyr_x;
    memoria[cont_m][5]=fgyr_y;
    memoria[cont_m][6]=fgyr_z;
    memoria[cont_m][7]=ftemp;

    myled = !myled;
}
