#include "mbed.h"
 
 
/*****************************************************************************
generar un programa que controle por el puerto serial el grado de 4 servo motores.
por medio de la comunicacion serial el comando es 
 
|            |            |             |
|   INITCMD  |     TC     |     PA      |
|    0xFF    | 0x01- 0x02 | 0x00 - 0x06 |
 
para enviar los comandos usar el programa Coolterm http://freeware.the-meiers.org/
 
# para el servo motor se debe modificar el ciclo util del PWM SEGUN:
#     ________              ________
# ___|        |____________|        |___________
#    <-width->
#    <-------period 20ms--->
# period = 20 ms
# width  = 1000us y 2400us
#  1000us para 0 grados
#  2400us para 180 grados
 
 
*****************************************************************************/
 
 
Serial command(USBTX, USBRX);
PwmOut myservo1(PA_9);
PwmOut myservo2(PC_7);
PwmOut myservo3(PB_6);
PwmOut myservo4(PA_7);
/*INGRESE LA CONFIGURACION DE LOS MOTORES*/
 
#define INITCMD 0xFF
#define DEGREES_MAX 180
 
// definición de las variables globales 
 
uint8_t TC;    // Telecomando - variable almacena el movimiento en leer_datos()
uint8_t PA;    // Parametro - varable almacena los grados a los que se mueven los motores en leer_datos()
 
 
// definición de las funciones
void setup_uart();
void setup_servo();
 
void mover_brazo(uint8_t PA);
void mover_pinza(uint8_t PA);
void mover_servo(uint8_t motor, uint8_t grados);
uint32_t degrees2usec(uint8_t grados);
 
void leer_datos();
 
    
    
int main() {
 
    setup_uart();
    setup_servo();
    
    mover_servo(1, 38);
    mover_servo(2, 60);//MAX 75 CUANDO  3-150
    mover_servo(3, 90);
    mover_servo(4, 170);//CIERRA 170 AA ABRE 150 96
    
    command.printf("inicio de programa");
    while(1){    
        leer_datos();//SEGUNDO VALOR HEXADECIMAL 01 - 02...06
        switch(TC){
            case 0x01:
                mover_brazo(PA);
                break;
            case 0x02:
                mover_pinza(PA);
                break;
            default:
                if(TC<=06)
                mover_servo(TC-2, PA);
                break; 
        }
    }    
}
 
void mover_brazo(uint8_t PA){//TERCERO DATO HEXADECIMAL SI QUIERE MOVER BRAZO
    switch(PA){
        case 0x01: //Home
            mover_servo(1, 38);//POSICION MATERIAL HOME
            mover_servo(2, 60);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 90);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 170);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        case 0x02: //Material
            mover_servo(1, 2);//POSICION MATERIAL HOME
            mover_servo(2, 100);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 85);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        case 0x03: //Celda 1
            mover_servo(1, 78);//POSICION CELDA 1
            mover_servo(2, 70);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 150);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        case 0x04: //Celda 2
            mover_servo(1, 103);//POSICION CELDA 2
            mover_servo(2, 70);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 150);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        case 0x05: //Celda 3
            mover_servo(1, 128);//POSICION CELDA 3
            mover_servo(2, 70);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 150);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        case 0x06: //Celda 4
            mover_servo(1, 153);//POSICION CELDA 4
            mover_servo(2, 70);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 150);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;
        default: 
            mover_servo(1, 178);//POSICION CELDA 5
            mover_servo(2, 70);//0 ATRAS PINZA - 180 ADELANTE PINZA
            mover_servo(3, 150);//0 BAJA PINZA - 180 SUBE PINZA
            mover_servo(4, 150);//150 ABRE PINZA - 170 CIERRA PINZA
            break;      
    }
} 
 
void mover_pinza(uint8_t PA){ //TERCERO DATO HEXADECIMAL SI QUIERE MOVER PINZA
    switch(PA){
        case 0x01:
            mover_servo(4, 170);//170 CIERRA PINZA
            break;
        case 0x02:
            mover_servo(4, 150);//150 ABRE PINZA
            break;
    }
}
 
void setup_uart(){
    command.baud(9600);
}
 
void setup_servo(){
    myservo1.period_us(20000);
    myservo1.pulsewidth_us(2000);
}
 
void leer_datos(){
    while(command.getc()!= INITCMD);
    TC=command.getc();
    PA=command.getc();
}
 
 
uint32_t degrees2usec(uint8_t grados){
// Retorna el valor en microsegundos, donde
//      y − y1 = m(x − x1 )
//      y=  b + mx
 
    if(grados <= DEGREES_MAX)
        return int(457+grados*1880/180);// u6
    return 457;
    
}
 
void mover_servo(uint8_t motor, uint8_t grados){
 
        uint32_t dpulse=0;
        
/* complementar el código necesario
   tip: deben pasar  grados a microsegundo */
 
 
    dpulse=degrees2usec(grados);
    if (motor==1)
         myservo1.pulsewidth_us(dpulse);
    if (motor==2)
         myservo2.pulsewidth_us(dpulse);
    if (motor==3)
         myservo3.pulsewidth_us(dpulse);
    if (motor==4)
         myservo4.pulsewidth_us(dpulse);         
}
